/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.core.context;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.impl.core.ObjectStore;
import org.jboss.arquillian.impl.core.context.SuiteContextImpl;
import org.jboss.arquillian.impl.core.spi.context.SuiteContext;
import org.junit.Assert;
import org.junit.Test;

public class ContextActivationTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToReceiveObjectAfterReActivation() {
        SuiteContextImpl context = new SuiteContextImpl();
        try {
            Assert.assertFalse((boolean)context.isActive());
            context.activate();
            Assert.assertTrue((boolean)context.isActive());
            ObjectStore store = context.getObjectStore();
            store.add(Boolean.class, (Object)true);
            Assert.assertEquals((String)"Verify that we can get objects from a active context", (Object)new Boolean(true), (Object)store.get(Boolean.class));
            context.deactivate();
            Assert.assertFalse((boolean)context.isActive());
            try {
                context.getObjectStore();
                Assert.fail((String)"Trying to get ObjectStore outside active context should have thrown Exception");
            }
            catch (Exception exception) {
                // empty catch block
            }
            context.activate();
            store = context.getObjectStore();
            Assert.assertEquals((String)"Verify that we can get objects from a active context", (Object)new Boolean(true), (Object)store.get(Boolean.class));
        }
        finally {
            context.deactivate();
            context.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotBeAbleToReadFromDifferentThread() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        SuiteContextImpl context = new SuiteContextImpl();
        try {
            context.activate();
            context.getObjectStore().add(Object.class, new Object());
            Thread thread = new Thread((SuiteContext)context, latch){
                final /* synthetic */ SuiteContext val$context;
                final /* synthetic */ CountDownLatch val$latch;
                {
                    this.val$context = suiteContext;
                    this.val$latch = countDownLatch;
                }

                public void run() {
                    Assert.assertFalse((boolean)this.val$context.isActive());
                    this.val$latch.countDown();
                }
            };
            thread.start();
            if (!latch.await(1L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Thread never called?");
            }
        }
        finally {
            context.deactivate();
            context.destroy();
        }
    }
}

