/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.domain;

import java.util.HashMap;
import junit.framework.Assert;
import org.jboss.arquillian.impl.domain.ProtocolDefinition;
import org.jboss.arquillian.impl.domain.ProtocolRegistry;
import org.jboss.arquillian.spi.client.protocol.Protocol;
import org.jboss.arquillian.spi.client.protocol.ProtocolConfiguration;
import org.jboss.arquillian.spi.client.protocol.ProtocolDescription;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ProtocolRegistryTestCase {
    private String name = "some-name";
    @Mock
    private Protocol<DummyProtocolConfiguration> protocol;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.protocol.getDescription()).thenReturn((Object)new ProtocolDescription(this.name));
        Mockito.when((Object)this.protocol.getProtocolConfigurationClass()).thenReturn(DummyProtocolConfiguration.class);
    }

    @Test
    public void shouldBeAbleToDefaultProtocolIfOnlyOneFound() throws Exception {
        ProtocolRegistry registry = this.createRegistry().addProtocol(new ProtocolDefinition(this.protocol, new HashMap()));
        Assert.assertEquals(this.protocol, (Object)registry.getProtocol(ProtocolDescription.DEFAULT).getProtocol());
    }

    @Test
    public void shouldBeAbleToDefaultToProtocolMakedAsDefault() throws Exception {
        Protocol localProtocol = (Protocol)Mockito.mock(Protocol.class);
        Mockito.when((Object)localProtocol.getDescription()).thenReturn((Object)new ProtocolDescription("local"));
        Protocol otherProtocol = (Protocol)Mockito.mock(Protocol.class);
        Mockito.when((Object)otherProtocol.getDescription()).thenReturn((Object)new ProtocolDescription("other"));
        ProtocolRegistry registry = this.createRegistry().addProtocol(new ProtocolDefinition(this.protocol, new HashMap(), true)).addProtocol(new ProtocolDefinition(localProtocol, new HashMap())).addProtocol(new ProtocolDefinition(otherProtocol, new HashMap()));
        Assert.assertEquals(this.protocol, (Object)registry.getProtocol(ProtocolDescription.DEFAULT).getProtocol());
    }

    @Test
    public void shouldReturnNullTryingToDefaultWithMultipleNonDefinedDefaultProtocols() throws Exception {
        Protocol localProtocol = (Protocol)Mockito.mock(Protocol.class);
        Mockito.when((Object)localProtocol.getDescription()).thenReturn((Object)new ProtocolDescription("local"));
        Protocol otherProtocol = (Protocol)Mockito.mock(Protocol.class);
        Mockito.when((Object)otherProtocol.getDescription()).thenReturn((Object)new ProtocolDescription("other"));
        ProtocolRegistry registry = this.createRegistry().addProtocol(new ProtocolDefinition(this.protocol, new HashMap())).addProtocol(new ProtocolDefinition(localProtocol, new HashMap())).addProtocol(new ProtocolDefinition(otherProtocol, new HashMap()));
        Assert.assertNull((Object)registry.getProtocol(ProtocolDescription.DEFAULT));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionIfMultipleProtocolsWithTheSameDescription() {
        this.createRegistry().addProtocol(new ProtocolDefinition(this.protocol, new HashMap())).addProtocol(new ProtocolDefinition(this.protocol, new HashMap()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionOnNullProtocolRegistration() throws Exception {
        this.createRegistry().addProtocol(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionOnNullProtocolLookup() throws Exception {
        this.createRegistry().getProtocol(null);
    }

    protected ProtocolRegistry createRegistry() {
        return new ProtocolRegistry();
    }

    @Test
    public void shouldBeAbleToMatchAndConfigureProtocol() throws Exception {
    }

    public static class DummyProtocolConfiguration
    implements ProtocolConfiguration {
        private String property;

        public void setProperty(String property) {
            this.property = property;
        }

        public String getProperty() {
            return this.property;
        }
    }
}

