/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.enricher;

import java.util.Arrays;
import org.jboss.arquillian.impl.AbstractManagerTestBase;
import org.jboss.arquillian.impl.core.ManagerBuilder;
import org.jboss.arquillian.impl.domain.Container;
import org.jboss.arquillian.impl.enricher.ClientTestEnricher;
import org.jboss.arquillian.spi.ServiceLoader;
import org.jboss.arquillian.spi.TestEnricher;
import org.jboss.arquillian.spi.core.annotation.SuiteScoped;
import org.jboss.arquillian.spi.event.enrichment.AfterEnrichment;
import org.jboss.arquillian.spi.event.enrichment.BeforeEnrichment;
import org.jboss.arquillian.spi.event.suite.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ClientTestEnricherTestCase
extends AbstractManagerTestBase {
    @Mock
    private ServiceLoader serviceLoader;
    @Mock
    private TestEnricher enricher;
    @Mock
    private Container container;

    protected void addExtensions(ManagerBuilder builder) {
        builder.extension(ClientTestEnricher.class);
    }

    @Test
    public void shouldCallAllEnrichers() throws Exception {
        ClassLoader cl = this.getClass().getClassLoader();
        Mockito.when((Object)this.serviceLoader.all(cl, TestEnricher.class)).thenReturn(Arrays.asList(this.enricher, this.enricher));
        Mockito.when((Object)this.container.getClassLoader()).thenReturn((Object)cl);
        this.bind(SuiteScoped.class, ServiceLoader.class, this.serviceLoader);
        this.bind(SuiteScoped.class, Container.class, this.container);
        this.fire(new Before((Object)this, this.getClass().getMethod("shouldCallAllEnrichers", new Class[0])));
        ((TestEnricher)Mockito.verify((Object)this.enricher, (VerificationMode)Mockito.times((int)2))).enrich((Object)this);
        this.assertEventFired(BeforeEnrichment.class, 1);
        this.assertEventFired(AfterEnrichment.class, 1);
    }
}

