/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.enricher.resource;

import java.net.URL;
import junit.framework.Assert;
import org.jboss.arquillian.api.ArquillianResource;
import org.jboss.arquillian.impl.AbstractManagerTestBase;
import org.jboss.arquillian.impl.core.ManagerBuilder;
import org.jboss.arquillian.impl.enricher.resource.ArquillianResourceTestEnricher;
import org.jboss.arquillian.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.spi.client.protocol.metadata.Servlet;
import org.jboss.arquillian.spi.core.Injector;
import org.jboss.arquillian.spi.core.Instance;
import org.jboss.arquillian.spi.core.annotation.ApplicationScoped;
import org.jboss.arquillian.spi.core.annotation.Inject;
import org.junit.Test;

public class ArquillianTestEnricherContextTestCase
extends AbstractManagerTestBase {
    @Inject
    private Instance<Injector> injector;

    protected void addExtensions(ManagerBuilder builder) {
    }

    @Test
    public void shouldBeAbleToInjectBaseContext() throws Exception {
        this.bind(ApplicationScoped.class, ProtocolMetaData.class, new ProtocolMetaData().addContext((Object)new HTTPContext("TEST", 8080)));
        ArquillianResourceTestEnricher enricher = new ArquillianResourceTestEnricher();
        ((Injector)this.injector.get()).inject((Object)enricher);
        URLBaseContextClass test = new URLBaseContextClass();
        enricher.enrich((Object)test);
        Assert.assertEquals((String)"http://TEST:8080", (String)test.url.toExternalForm());
    }

    @Test
    public void shouldBeAbleToInjectServlet() throws Exception {
        this.bind(ApplicationScoped.class, ProtocolMetaData.class, new ProtocolMetaData().addContext((Object)new HTTPContext("TEST", 8080).add(new Servlet(URLServletContextClass.class.getSimpleName(), "/test"))));
        ArquillianResourceTestEnricher enricher = new ArquillianResourceTestEnricher();
        ((Injector)this.injector.get()).inject((Object)enricher);
        URLServletContextClass test = new URLServletContextClass();
        enricher.enrich((Object)test);
        Assert.assertEquals((String)"http://TEST:8080/test/", (String)test.url.toExternalForm());
    }

    public class URLServletContextClass {
        @ArquillianResource(value=URLServletContextClass.class)
        public URL url;
    }

    public class URLBaseContextClass {
        @ArquillianResource
        public URL url;
    }
}

