/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.execution;

import java.lang.reflect.Method;
import org.jboss.arquillian.api.RunAsClient;
import org.jboss.arquillian.impl.AbstractManagerTestBase;
import org.jboss.arquillian.impl.core.ManagerBuilder;
import org.jboss.arquillian.impl.execution.ClientTestExecuter;
import org.jboss.arquillian.impl.execution.event.LocalExecutionEvent;
import org.jboss.arquillian.impl.execution.event.RemoteExecutionEvent;
import org.jboss.arquillian.spi.TestMethodExecutor;
import org.jboss.arquillian.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.spi.core.annotation.ApplicationScoped;
import org.jboss.arquillian.spi.event.suite.Test;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ClientTestExecuterTestCase
extends AbstractManagerTestBase {
    @Mock
    private DeploymentDescription deployment;

    protected void addExtensions(ManagerBuilder builder) {
        builder.extension(ClientTestExecuter.class);
    }

    @Before
    public void bindDeployment() {
        this.bind(ApplicationScoped.class, DeploymentDescription.class, this.deployment);
    }

    @org.junit.Test
    public void shouldExecuteRemoteIfDeploymentIsTestable() throws Exception {
        Mockito.when((Object)this.deployment.testable()).thenReturn((Object)true);
        this.fire(this.test("methodLevelRunModeDefault", new ClassLevelRunModeDefault()));
        this.assertEventFired(RemoteExecutionEvent.class, 1);
    }

    @org.junit.Test
    public void shouldExecuteLocalIfDeploymentIsNotTestable() throws Exception {
        Mockito.when((Object)this.deployment.testable()).thenReturn((Object)false);
        this.fire(this.test("methodLevelRunModeDefault", new ClassLevelRunModeDefault()));
        this.assertEventFired(LocalExecutionEvent.class, 1);
    }

    @org.junit.Test
    public void shouldExecuteLocalIfDeploymentIsTestableAndClassRunModeAsClient() throws Exception {
        Mockito.when((Object)this.deployment.testable()).thenReturn((Object)true);
        this.fire(this.test("methodLevelRunModeDefault", new ClassLevelRunModeAsClient()));
        this.assertEventFired(LocalExecutionEvent.class, 1);
    }

    @org.junit.Test
    public void shouldExecuteLocalIfDeploymentIsTestableAndMethodRunModeAsClient() throws Exception {
        Mockito.when((Object)this.deployment.testable()).thenReturn((Object)true);
        this.fire(this.test("methodLevelRunModeAsClient", new ClassLevelRunModeDefault()));
        this.assertEventFired(LocalExecutionEvent.class, 1);
    }

    private Test test(String testMethodName, Object obj) throws Exception {
        TestMethodExecutor executor = (TestMethodExecutor)Mockito.mock(TestMethodExecutor.class);
        Mockito.when((Object)executor.getInstance()).thenReturn(obj);
        Mockito.when((Object)executor.getMethod()).thenReturn((Object)this.method(testMethodName));
        return new Test(executor);
    }

    private Method method(String name) throws Exception {
        return this.getClass().getDeclaredMethod(name, new Class[0]);
    }

    private void methodLevelRunModeDefault() {
    }

    private void methodLevelRunModeInContainer() {
    }

    @RunAsClient
    private void methodLevelRunModeAsClient() {
    }

    @RunAsClient
    private static class ClassLevelRunModeAsClient {
        private ClassLevelRunModeAsClient() {
        }
    }

    private static class ClassLevelRunModeDefault {
        private ClassLevelRunModeDefault() {
        }
    }
}

