/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.execution;

import java.lang.reflect.Method;
import junit.framework.Assert;
import org.jboss.arquillian.impl.AbstractManagerTestBase;
import org.jboss.arquillian.impl.core.ManagerBuilder;
import org.jboss.arquillian.impl.execution.LocalTestExecuter;
import org.jboss.arquillian.impl.execution.event.LocalExecutionEvent;
import org.jboss.arquillian.spi.ServiceLoader;
import org.jboss.arquillian.spi.TestMethodExecutor;
import org.jboss.arquillian.spi.TestResult;
import org.jboss.arquillian.spi.core.annotation.ApplicationScoped;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class LocalTestExecuterTestCase
extends AbstractManagerTestBase {
    @Mock
    private TestMethodExecutor testExecutor;
    @Mock
    private ServiceLoader serviceLoader;

    protected void addExtensions(ManagerBuilder builder) {
        builder.extension(LocalTestExecuter.class);
    }

    @Test
    public void shouldReturnPassed() throws Throwable {
        this.bind(ApplicationScoped.class, ServiceLoader.class, this.serviceLoader);
        Mockito.when((Object)this.testExecutor.getInstance()).thenReturn((Object)this);
        Mockito.when((Object)this.testExecutor.getMethod()).thenReturn((Object)this.getTestMethod("shouldReturnPassed"));
        this.fire(new LocalExecutionEvent(this.testExecutor));
        TestResult result = (TestResult)this.getManager().resolve(TestResult.class);
        Assert.assertNotNull((String)"Should have set result", (Object)result);
        Assert.assertEquals((String)"Should have passed test", (Object)TestResult.Status.PASSED, (Object)result.getStatus());
        Assert.assertNull((String)"Should not have set cause", (Object)result.getThrowable());
    }

    @Test
    public void shouldReturnFailedOnException() throws Throwable {
        this.bind(ApplicationScoped.class, ServiceLoader.class, this.serviceLoader);
        Exception exception = new Exception();
        Mockito.when((Object)this.testExecutor.getInstance()).thenReturn((Object)this);
        Mockito.when((Object)this.testExecutor.getMethod()).thenReturn((Object)this.getTestMethod("shouldReturnFailedOnException"));
        ((TestMethodExecutor)Mockito.doThrow((Throwable)exception).when((Object)this.testExecutor)).invoke(new Object[0]);
        this.fire(new LocalExecutionEvent(this.testExecutor));
        TestResult result = (TestResult)this.getManager().resolve(TestResult.class);
        Assert.assertNotNull((String)"Should have set result", (Object)result);
        Assert.assertEquals((String)"Should have failed test", (Object)TestResult.Status.FAILED, (Object)result.getStatus());
        Assert.assertEquals((String)"Should have set failed cause", (Object)exception, (Object)result.getThrowable());
    }

    private Method getTestMethod(String name) throws Exception {
        return this.getClass().getMethod(name, new Class[0]);
    }
}

