/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.execution;

import java.lang.reflect.Method;
import junit.framework.Assert;
import org.jboss.arquillian.impl.AbstractManagerTestBase;
import org.jboss.arquillian.impl.core.ManagerBuilder;
import org.jboss.arquillian.impl.execution.RemoteTestExecuter;
import org.jboss.arquillian.impl.execution.event.RemoteExecutionEvent;
import org.jboss.arquillian.spi.ContainerMethodExecutor;
import org.jboss.arquillian.spi.TestMethodExecutor;
import org.jboss.arquillian.spi.TestResult;
import org.jboss.arquillian.spi.core.annotation.ClassScoped;
import org.jboss.arquillian.spi.event.suite.Test;
import org.junit.Ignore;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@Ignore
@RunWith(value=MockitoJUnitRunner.class)
public class RemoteTestExecuterTestCase
extends AbstractManagerTestBase {
    @Mock
    private ContainerMethodExecutor executor;
    @Mock
    private TestMethodExecutor testExecutor;

    protected void addExtensions(ManagerBuilder builder) {
        builder.extension(RemoteTestExecuter.class);
    }

    @org.junit.Test(expected=IllegalStateException.class)
    public void shouldThrowIllegalStateOnMissingContainerMethodExecutor() throws Exception {
        Mockito.when((Object)this.testExecutor.getInstance()).thenReturn((Object)this);
        Mockito.when((Object)this.testExecutor.getMethod()).thenReturn((Object)this.getTestMethod("shouldThrowIllegalStateOnMissingContainerMethodExecutor"));
        this.fire(new RemoteExecutionEvent(this.testExecutor));
    }

    @org.junit.Test
    public void shouldInvokeContainerMethodExecutor() throws Exception {
        TestResult result = new TestResult(TestResult.Status.PASSED);
        Mockito.when((Object)this.executor.invoke(this.testExecutor)).thenReturn((Object)result);
        Mockito.when((Object)this.testExecutor.getInstance()).thenReturn((Object)this);
        Mockito.when((Object)this.testExecutor.getMethod()).thenReturn((Object)this.getTestMethod("shouldInvokeContainerMethodExecutor"));
        this.bind(ClassScoped.class, ContainerMethodExecutor.class, this.executor);
        Test event = new Test(this.testExecutor);
        this.fire(event);
        ((ContainerMethodExecutor)Mockito.verify((Object)this.executor)).invoke(this.testExecutor);
    }

    @org.junit.Test
    public void shouldSetTestResult() throws Exception {
        TestResult result = new TestResult(TestResult.Status.PASSED);
        Mockito.when((Object)this.executor.invoke(this.testExecutor)).thenReturn((Object)result);
        Mockito.when((Object)this.testExecutor.getInstance()).thenReturn((Object)this);
        Mockito.when((Object)this.testExecutor.getMethod()).thenReturn((Object)this.getTestMethod("shouldSetTestResult"));
        this.bind(ClassScoped.class, ContainerMethodExecutor.class, this.executor);
        Test event = new Test(this.testExecutor);
        this.fire(event);
        Assert.assertEquals((String)"Should set result on event", (Object)result, (Object)this.getManager().resolve(TestResult.class));
    }

    private Method getTestMethod(String name) throws Exception {
        return this.getClass().getMethod(name, new Class[0]);
    }
}

