/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl;

import java.util.ArrayList;
import org.jboss.arquillian.impl.ArquillianProfile;
import org.jboss.arquillian.impl.DynamicServiceLoader;
import org.jboss.arquillian.impl.EventTestRunnerAdaptor;
import org.jboss.arquillian.impl.Validate;
import org.jboss.arquillian.impl.core.ManagerBuilder;
import org.jboss.arquillian.impl.core.context.ClassContextImpl;
import org.jboss.arquillian.impl.core.context.ContainerContextImpl;
import org.jboss.arquillian.impl.core.context.DeploymentContextImpl;
import org.jboss.arquillian.impl.core.context.SuiteContextImpl;
import org.jboss.arquillian.impl.core.context.TestContextImpl;
import org.jboss.arquillian.spi.ContainerProfile;
import org.jboss.arquillian.spi.Profile;
import org.jboss.arquillian.spi.TestRunnerAdaptor;

public class DeployableTestBuilder {
    private static ContainerProfile profile = null;

    private DeployableTestBuilder() {
    }

    public static void setProfile(ContainerProfile profile) {
        Validate.notNull(profile, "Profile must be specified");
        DeployableTestBuilder.profile = profile;
    }

    public static ContainerProfile getProfile() {
        return profile;
    }

    public static void clearProfile() {
        profile = null;
    }

    public static TestRunnerAdaptor build() {
        return DeployableTestBuilder.build(profile == null ? ContainerProfile.CLIENT : profile);
    }

    public static TestRunnerAdaptor build(ContainerProfile profileType) {
        DynamicServiceLoader serviceLoader = new DynamicServiceLoader();
        ManagerBuilder builder = ManagerBuilder.from().context(SuiteContextImpl.class).context(ClassContextImpl.class).context(TestContextImpl.class).context(ContainerContextImpl.class).context(DeploymentContextImpl.class);
        ArrayList<ArquillianProfile> profiles = new ArrayList<ArquillianProfile>();
        profiles.add(new ArquillianProfile());
        profiles.addAll(serviceLoader.all(Profile.class));
        for (Profile profile : profiles) {
            switch (profileType) {
                case CLIENT: {
                    builder.extensions(profile.getClientProfile().toArray(new Class[0]));
                    break;
                }
                case CONTAINER: {
                    builder.extensions(profile.getContainerProfile().toArray(new Class[0]));
                }
            }
        }
        return new EventTestRunnerAdaptor(builder.create());
    }
}

