/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.client.container;

import java.util.List;
import java.util.concurrent.Callable;
import org.jboss.arquillian.impl.client.container.event.DeployDeployment;
import org.jboss.arquillian.impl.client.container.event.DeployManagedDeployments;
import org.jboss.arquillian.impl.client.container.event.DeploymentEvent;
import org.jboss.arquillian.impl.client.container.event.UnDeployDeployment;
import org.jboss.arquillian.impl.client.container.event.UnDeployManagedDeployments;
import org.jboss.arquillian.impl.domain.Container;
import org.jboss.arquillian.impl.domain.ContainerRegistry;
import org.jboss.arquillian.spi.client.container.DeployableContainer;
import org.jboss.arquillian.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.spi.client.deployment.DeploymentScenario;
import org.jboss.arquillian.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.spi.client.test.TargetDescription;
import org.jboss.arquillian.spi.core.Event;
import org.jboss.arquillian.spi.core.Injector;
import org.jboss.arquillian.spi.core.Instance;
import org.jboss.arquillian.spi.core.InstanceProducer;
import org.jboss.arquillian.spi.core.annotation.DeploymentScoped;
import org.jboss.arquillian.spi.core.annotation.Inject;
import org.jboss.arquillian.spi.core.annotation.Observes;
import org.jboss.arquillian.spi.event.container.AfterDeploy;
import org.jboss.arquillian.spi.event.container.AfterUnDeploy;
import org.jboss.arquillian.spi.event.container.BeforeDeploy;
import org.jboss.arquillian.spi.event.container.BeforeUnDeploy;
import org.jboss.arquillian.spi.event.container.DeployerEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerDeployController {
    @Inject
    private Instance<ContainerRegistry> containerRegistry;
    @Inject
    private Instance<DeploymentScenario> deploymentScenario;
    @Inject
    private Instance<Injector> injector;

    public void deployManaged(@Observes DeployManagedDeployments event) throws Exception {
        this.forEachManagedDeployment(new Operation<Container, DeploymentDescription>(){
            @Inject
            private Event<DeploymentEvent> event;

            @Override
            public void perform(Container container, DeploymentDescription deployment) throws Exception {
                this.event.fire((Object)new DeployDeployment(container, deployment));
            }
        });
    }

    public void undeployManaged(@Observes UnDeployManagedDeployments event) throws Exception {
        this.forEachManagedDeployment(new Operation<Container, DeploymentDescription>(){
            @Inject
            private Event<DeploymentEvent> event;

            @Override
            public void perform(Container container, DeploymentDescription deployment) throws Exception {
                this.event.fire((Object)new UnDeployDeployment(container, deployment));
            }
        });
    }

    public void deploy(final @Observes DeployDeployment event) throws Exception {
        this.executeOperation(new Callable<Void>(){
            @Inject
            private Event<DeployerEvent> deployEvent;
            @Inject
            @DeploymentScoped
            private InstanceProducer<DeploymentDescription> deploymentDescription;
            @Inject
            @DeploymentScoped
            private InstanceProducer<ProtocolMetaData> protocolMetadata;

            @Override
            public Void call() throws Exception {
                DeployableContainer<?> deployableContainer = event.getDeployableContainer();
                DeploymentDescription deployment = event.getDeployment();
                this.deploymentDescription.set((Object)deployment);
                this.deployEvent.fire((Object)new BeforeDeploy(deployableContainer, deployment));
                if (deployment.isArchiveDeployment()) {
                    this.protocolMetadata.set((Object)deployableContainer.deploy(deployment.getTestableArchive() != null ? deployment.getTestableArchive() : deployment.getArchive()));
                } else {
                    deployableContainer.deploy(deployment.getDescriptor());
                }
                this.deployEvent.fire((Object)new AfterDeploy(deployableContainer, deployment));
                return null;
            }
        });
    }

    public void undeploy(final @Observes UnDeployDeployment event) throws Exception {
        this.executeOperation(new Callable<Void>(){
            @Inject
            private Event<DeployerEvent> deployEvent;

            /*
             * Unable to fully structure code
             */
            @Override
            public Void call() throws Exception {
                deployableContainer = event.getDeployableContainer();
                deployment = event.getDeployment();
                this.deployEvent.fire((Object)new BeforeUnDeploy(deployableContainer, deployment));
                if (deployment.isArchiveDeployment()) {
                    try {
                        deployableContainer.undeploy(deployment.getTestableArchive() != null ? deployment.getTestableArchive() : deployment.getArchive());
                    }
                    catch (Exception e) {
                        if (deployment.getExpectedException() != null) ** GOTO lbl12
                        throw e;
                    }
                } else {
                    deployableContainer.undeploy(deployment.getDescriptor());
                }
lbl12:
                // 3 sources

                this.deployEvent.fire((Object)new AfterUnDeploy(deployableContainer, deployment));
                return null;
            }
        });
    }

    private void forEachManagedDeployment(Operation<Container, DeploymentDescription> operation) throws Exception {
        ((Injector)this.injector.get()).inject(operation);
        ContainerRegistry containerRegistry = (ContainerRegistry)this.containerRegistry.get();
        DeploymentScenario deploymentScenario = (DeploymentScenario)this.deploymentScenario.get();
        for (TargetDescription target : deploymentScenario.getTargets()) {
            List startUpDeployments = deploymentScenario.getStartupDeploymentsFor(target);
            if (startUpDeployments.size() == 0) continue;
            Container container = containerRegistry.getContainer(target);
            for (DeploymentDescription deployment : startUpDeployments) {
                operation.perform(container, deployment);
            }
        }
    }

    private void executeOperation(Callable<Void> operation) throws Exception {
        ((Injector)this.injector.get()).inject(operation);
        operation.call();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Operation<T, X> {
        public void perform(T var1, X var2) throws Exception;
    }
}

