/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.client.deployment;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jboss.arquillian.api.Deployment;
import org.jboss.arquillian.api.OverProtocol;
import org.jboss.arquillian.api.ShouldThrowException;
import org.jboss.arquillian.api.TargetsContainer;
import org.jboss.arquillian.spi.TestClass;
import org.jboss.arquillian.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.spi.client.deployment.DeploymentScenario;
import org.jboss.arquillian.spi.client.deployment.DeploymentScenarioGenerator;
import org.jboss.arquillian.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.spi.client.test.TargetDescription;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationDeploymentScenarioGenerator
implements DeploymentScenarioGenerator {
    public DeploymentScenario generate(TestClass testClass) {
        DeploymentScenario scenario = new DeploymentScenario();
        Method[] deploymentMethods = testClass.getMethods(Deployment.class);
        this.validate(deploymentMethods);
        for (Method deploymentMethod : deploymentMethods) {
            this.validate(deploymentMethod);
            scenario.addDeployment(this.generateDeployment(deploymentMethod));
        }
        return scenario;
    }

    private void validate(Method[] deploymentMethods) {
        if (deploymentMethods == null || deploymentMethods.length == 0) {
            throw new IllegalArgumentException("No methods annotated with " + Deployment.class.getName() + " found");
        }
    }

    private void validate(Method deploymentMethod) {
        if (!Modifier.isStatic(deploymentMethod.getModifiers())) {
            throw new IllegalArgumentException("Method annotated with " + Deployment.class.getName() + " is not static. " + deploymentMethod);
        }
        if (!Archive.class.isAssignableFrom(deploymentMethod.getReturnType()) && !Descriptor.class.isAssignableFrom(deploymentMethod.getReturnType())) {
            throw new IllegalArgumentException("Method annotated with " + Deployment.class.getName() + " must have return type " + Archive.class.getName() + " or " + Descriptor.class.getName() + ". " + deploymentMethod);
        }
        if (deploymentMethod.getParameterTypes().length != 0) {
            throw new IllegalArgumentException("Method annotated with " + Deployment.class.getName() + " can not accept parameters. " + deploymentMethod);
        }
    }

    private DeploymentDescription generateDeployment(Method deploymentMethod) {
        TargetDescription target = this.generateTarget(deploymentMethod);
        ProtocolDescription protocol = this.generateProtocol(deploymentMethod);
        Deployment deploymentAnnotation = deploymentMethod.getAnnotation(Deployment.class);
        DeploymentDescription deployment = null;
        if (Archive.class.isAssignableFrom(deploymentMethod.getReturnType())) {
            deployment = new DeploymentDescription(deploymentAnnotation.name(), this.invoke(Archive.class, deploymentMethod));
            deployment.shouldBeTestable(deploymentAnnotation.testable());
        } else if (Descriptor.class.isAssignableFrom(deploymentMethod.getReturnType())) {
            deployment = new DeploymentDescription(deploymentAnnotation.name(), this.invoke(Descriptor.class, deploymentMethod));
        }
        deployment.shouldBeManaged(deploymentAnnotation.managed());
        deployment.setOrder(deploymentAnnotation.order());
        if (target != null) {
            deployment.setTarget(target);
        }
        if (protocol != null) {
            deployment.setProtocol(protocol);
        }
        if (deploymentMethod.isAnnotationPresent(ShouldThrowException.class)) {
            deployment.setExpectedException(deploymentMethod.getAnnotation(ShouldThrowException.class).value());
            deployment.shouldBeTestable(false);
        }
        return deployment;
    }

    private TargetDescription generateTarget(Method deploymentMethod) {
        if (deploymentMethod.isAnnotationPresent(TargetsContainer.class)) {
            return new TargetDescription(deploymentMethod.getAnnotation(TargetsContainer.class).value());
        }
        return TargetDescription.DEFAULT;
    }

    private ProtocolDescription generateProtocol(Method deploymentMethod) {
        if (deploymentMethod.isAnnotationPresent(OverProtocol.class)) {
            return new ProtocolDescription(deploymentMethod.getAnnotation(OverProtocol.class).value());
        }
        return ProtocolDescription.DEFAULT;
    }

    private <T> T invoke(Class<T> type, Method deploymentMethod) {
        try {
            return type.cast(deploymentMethod.invoke(null, new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not invoke deployment method: " + deploymentMethod, e);
        }
    }
}

