/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.client.deployment;

import java.io.File;
import java.util.logging.Logger;
import org.jboss.arquillian.impl.configuration.api.ArquillianDescriptor;
import org.jboss.arquillian.impl.configuration.api.EngineDef;
import org.jboss.arquillian.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.spi.core.Instance;
import org.jboss.arquillian.spi.core.annotation.Inject;
import org.jboss.arquillian.spi.core.annotation.Observes;
import org.jboss.arquillian.spi.event.container.BeforeDeploy;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveDeploymentExporter {
    private static final Logger log = Logger.getLogger(ArchiveDeploymentExporter.class.getName());
    @Inject
    private Instance<ArquillianDescriptor> configuration;

    public void callback(@Observes BeforeDeploy event) throws Exception {
        String exportPath;
        ArquillianDescriptor descriptor = (ArquillianDescriptor)this.configuration.get();
        if (descriptor == null) {
            return;
        }
        EngineDef engine = descriptor.engine();
        String systemExport = System.getProperty("arquillian.deploymentExportPath");
        String string = exportPath = systemExport == null || systemExport.length() == 0 ? engine.getDeploymentExportPath() : systemExport;
        if (exportPath != null && event.getDeployment().isArchiveDeployment()) {
            File exportDir = new File(exportPath);
            if (exportDir.isFile()) {
                log.warning("Deployment export disabled. Export path points to an existing file: " + exportPath);
                return;
            }
            if (!exportDir.isDirectory() && !exportDir.mkdirs()) {
                log.warning("Deployment export directory could not be created: " + exportPath);
                return;
            }
            Archive deployment = event.getDeployment().testable() ? event.getDeployment().getTestableArchive() : event.getDeployment().getArchive();
            ((ZipExporter)deployment.as(ZipExporter.class)).exportTo(new File(exportDir, this.createFileName(event.getDeployment(), deployment)), true);
        }
    }

    private String createFileName(DeploymentDescription deployment, Archive<?> archive) {
        return deployment.getTarget().getName() + "_" + deployment.getName() + "_" + archive.getName();
    }
}

