/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.client.protocol;

import java.util.Collection;
import org.jboss.arquillian.impl.configuration.api.ArquillianDescriptor;
import org.jboss.arquillian.impl.configuration.api.DefaultProtocolDef;
import org.jboss.arquillian.impl.domain.ProtocolDefinition;
import org.jboss.arquillian.impl.domain.ProtocolRegistry;
import org.jboss.arquillian.spi.ServiceLoader;
import org.jboss.arquillian.spi.client.protocol.Protocol;
import org.jboss.arquillian.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.spi.core.Injector;
import org.jboss.arquillian.spi.core.Instance;
import org.jboss.arquillian.spi.core.InstanceProducer;
import org.jboss.arquillian.spi.core.annotation.ApplicationScoped;
import org.jboss.arquillian.spi.core.annotation.Inject;
import org.jboss.arquillian.spi.core.annotation.Observes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolRegistryCreator {
    @Inject
    private Instance<Injector> injector;
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    @Inject
    @ApplicationScoped
    private InstanceProducer<ProtocolRegistry> registryInstance;

    public void createRegistry(@Observes ArquillianDescriptor event) throws Exception {
        Collection protocols = ((ServiceLoader)this.serviceLoader.get()).all(Protocol.class);
        Protocol<?> defaultProtocol = null;
        DefaultProtocolDef defaultProtcolDef = event.getDefaultProtocol();
        if (defaultProtcolDef != null && (defaultProtocol = this.findMatch(new ProtocolDescription(defaultProtcolDef.getType()), protocols)) == null) {
            throw new IllegalStateException("Defined default protocol " + defaultProtcolDef.getType() + " can not be found on classpath");
        }
        ProtocolRegistry registry = new ProtocolRegistry();
        for (Protocol protocol : protocols) {
            ((Injector)this.injector.get()).inject((Object)protocol);
            if (defaultProtocol != null && protocol.equals(defaultProtocol)) {
                registry.addProtocol(new ProtocolDefinition(protocol, defaultProtcolDef.getProperties(), true));
                continue;
            }
            registry.addProtocol(new ProtocolDefinition(protocol));
        }
        this.registryInstance.set((Object)registry);
    }

    private Protocol<?> findMatch(ProtocolDescription description, Collection<Protocol> protocols) {
        for (Protocol protocol : protocols) {
            if (!description.equals((Object)protocol.getDescription())) continue;
            return protocol;
        }
        return null;
    }
}

