/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.jboss.arquillian.impl.core.Reflections;
import org.jboss.arquillian.impl.core.spi.InjectionPoint;
import org.jboss.arquillian.impl.core.spi.InvocationException;
import org.jboss.arquillian.spi.core.Instance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionPointImpl
implements InjectionPoint {
    private Object target;
    private Field field;
    private Class<? extends Annotation> scope;

    public static InjectionPointImpl of(Object target, Field field) {
        return new InjectionPointImpl(target, field, Reflections.getScope(field));
    }

    InjectionPointImpl(Object target, Field field, Class<? extends Annotation> scope) {
        this.target = target;
        this.field = field;
        this.scope = scope;
    }

    @Override
    public Type getType() {
        ParameterizedType type = (ParameterizedType)this.field.getGenericType();
        if (type.getActualTypeArguments()[0] instanceof ParameterizedType) {
            ParameterizedType first = (ParameterizedType)type.getActualTypeArguments()[0];
            return (Class)first.getRawType();
        }
        return (Class)type.getActualTypeArguments()[0];
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    @Override
    public void set(Instance<?> value) throws InvocationException {
        try {
            if (!this.field.isAccessible()) {
                this.field.setAccessible(true);
            }
            this.field.set(this.target, value);
        }
        catch (Exception e) {
            throw new InvocationException(e.getCause());
        }
    }
}

