/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.core.context;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.jboss.arquillian.impl.core.ObjectStore;
import org.jboss.arquillian.impl.core.Validate;
import org.jboss.arquillian.impl.core.context.IdBoundContext;
import org.jboss.arquillian.impl.core.spi.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContext<T>
implements Context,
IdBoundContext<T> {
    private static Logger log = Logger.getLogger("Context");
    private ConcurrentHashMap<T, ObjectStore> stores;
    private ThreadLocal<ObjectStore> activeStore = new ThreadLocal();

    public AbstractContext() {
        this.stores = new ConcurrentHashMap();
    }

    @Override
    public void activate(T id) {
        Validate.notNull(id, "ID must be specified");
        if (!this.isActive()) {
            this.activeStore.set(this.createObjectStore(id));
        } else {
            log.info("Trying to activate context, but allready active: " + super.getClass().getSimpleName() + " " + id);
        }
    }

    @Override
    public void deactivate() {
        if (this.isActive()) {
            this.activeStore.set(null);
        } else {
            log.info("Trying to deactivate context, but none active: " + super.getClass().getSimpleName());
        }
    }

    @Override
    public boolean isActive() {
        return this.activeStore.get() != null;
    }

    @Override
    public void destroy(T id) {
        ObjectStore store = this.stores.remove(id);
        if (store != null) {
            store.clear();
        }
    }

    @Override
    public ObjectStore getObjectStore() {
        if (this.isActive()) {
            return this.activeStore.get();
        }
        throw new RuntimeException("Context is not active: " + super.getClass().getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAll() {
        AbstractContext abstractContext = this;
        synchronized (abstractContext) {
            if (this.isActive()) {
                this.deactivate();
            }
            for (Map.Entry<T, ObjectStore> entry : this.stores.entrySet()) {
                entry.getValue().clear();
            }
            this.stores.clear();
        }
    }

    private ObjectStore createObjectStore(T id) {
        Validate.notNull(id, "ID must be specified");
        ObjectStore store = new ObjectStore();
        ObjectStore previousStore = this.stores.putIfAbsent(id, store);
        if (previousStore != null) {
            return previousStore;
        }
        return store;
    }
}

