/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.domain;

import java.util.ArrayList;
import java.util.List;
import org.jboss.arquillian.impl.Validate;
import org.jboss.arquillian.impl.domain.ProtocolDefinition;
import org.jboss.arquillian.spi.client.protocol.ProtocolDescription;

public class ProtocolRegistry {
    private List<ProtocolDefinition> protocols = new ArrayList<ProtocolDefinition>();

    public ProtocolRegistry addProtocol(ProtocolDefinition protocolDefinition) {
        Validate.notNull(protocolDefinition, "ProtocolDefinition must be specified");
        ProtocolDefinition protocolAllReadyRegistered = this.findSpecificProtocol(protocolDefinition.getProtocol().getDescription());
        if (protocolAllReadyRegistered != null) {
            throw new IllegalArgumentException("Protocol with description " + protocolDefinition.getProtocol().getDescription() + " allready registered. " + "Registered " + protocolAllReadyRegistered.getClass() + ", trying to register " + protocolDefinition.getProtocol().getClass());
        }
        this.protocols.add(protocolDefinition);
        return this;
    }

    public ProtocolDefinition getProtocol(ProtocolDescription protocolDescription) {
        Validate.notNull(protocolDescription, "ProtocolDescription must be specified");
        if (ProtocolDescription.DEFAULT.equals((Object)protocolDescription)) {
            return this.findDefaultProtocol();
        }
        return this.findSpecificProtocol(protocolDescription);
    }

    private ProtocolDefinition findDefaultProtocol() {
        for (ProtocolDefinition def : this.protocols) {
            if (!def.isDefaultProtocol()) continue;
            return def;
        }
        if (this.protocols.size() == 1) {
            return this.protocols.get(0);
        }
        return null;
    }

    private ProtocolDefinition findSpecificProtocol(ProtocolDescription protocolDescription) {
        for (ProtocolDefinition protocol : this.protocols) {
            if (!protocolDescription.equals((Object)protocol.getProtocol().getDescription())) continue;
            return protocol;
        }
        return null;
    }
}

