/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.enricher.resource;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.jboss.arquillian.api.ArquillianResource;
import org.jboss.arquillian.api.Deployer;
import org.jboss.arquillian.impl.enricher.resource.DeployerProvider;
import org.jboss.arquillian.impl.enricher.resource.InitialContextProvider;
import org.jboss.arquillian.impl.enricher.resource.ResourceProvider;
import org.jboss.arquillian.impl.enricher.resource.SecurityActions;
import org.jboss.arquillian.impl.enricher.resource.URIResourceProvider;
import org.jboss.arquillian.impl.enricher.resource.URLResourceProvider;
import org.jboss.arquillian.spi.TestEnricher;
import org.jboss.arquillian.spi.core.Injector;
import org.jboss.arquillian.spi.core.Instance;
import org.jboss.arquillian.spi.core.annotation.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArquillianResourceTestEnricher
implements TestEnricher {
    private static Map<Class<?>, ResourceProvider> providers = new HashMap();
    @Inject
    private Instance<Injector> injector;

    public void enrich(Object testCase) {
        for (Field field : SecurityActions.getFieldsWithAnnotation(testCase.getClass(), ArquillianResource.class)) {
            Object value = null;
            try {
                value = this.lookup(field.getType(), field.getAnnotation(ArquillianResource.class));
            }
            catch (Exception e) {
                throw new RuntimeException("Could not lookup value for field " + field, e);
            }
            try {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                field.set(testCase, value);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not set value on field " + field + " using " + value);
            }
        }
    }

    public Object[] resolve(Method method) {
        Object[] values = new Object[method.getParameterTypes().length];
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            ArquillianResource resource = this.getResourceAnnotation(method.getParameterAnnotations()[i]);
            if (resource == null) continue;
            values[i] = this.lookup(method.getParameterTypes()[i], resource);
        }
        return values;
    }

    private Object lookup(Class<?> type, ArquillianResource resource) {
        ResourceProvider provider = providers.get(type);
        if (provider == null) {
            throw new IllegalArgumentException("No ResourceProvider found for type: " + type);
        }
        ((Injector)this.injector.get()).inject((Object)provider);
        Object value = provider.lookup(resource);
        if (value == null) {
            throw new RuntimeException("Provider for type " + type + " returned a null value: " + provider);
        }
        return value;
    }

    private ArquillianResource getResourceAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != ArquillianResource.class) continue;
            return (ArquillianResource)annotation;
        }
        return null;
    }

    static {
        providers.put(URL.class, new URLResourceProvider());
        providers.put(URI.class, new URIResourceProvider());
        providers.put(InitialContext.class, new InitialContextProvider());
        providers.put(Context.class, new InitialContextProvider());
        providers.put(Deployer.class, new DeployerProvider());
    }
}

