/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.impl.execution;

import org.jboss.arquillian.api.RunAsClient;
import org.jboss.arquillian.impl.execution.event.ExecutionEvent;
import org.jboss.arquillian.impl.execution.event.LocalExecutionEvent;
import org.jboss.arquillian.impl.execution.event.RemoteExecutionEvent;
import org.jboss.arquillian.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.spi.core.Event;
import org.jboss.arquillian.spi.core.Instance;
import org.jboss.arquillian.spi.core.annotation.Inject;
import org.jboss.arquillian.spi.core.annotation.Observes;
import org.jboss.arquillian.spi.event.suite.Test;

public class ClientTestExecuter {
    @Inject
    private Event<ExecutionEvent> executionEvent;
    @Inject
    private Instance<DeploymentDescription> deploymentDescription;

    public void execute(@Observes Test event) throws Exception {
        boolean runAsClient;
        DeploymentDescription deploymentDescription = (DeploymentDescription)this.deploymentDescription.get();
        boolean bl = runAsClient = !deploymentDescription.testable();
        if (event.getTestMethod().isAnnotationPresent(RunAsClient.class)) {
            runAsClient = true;
        } else if (event.getTestClass().isAnnotationPresent(RunAsClient.class)) {
            runAsClient = true;
        }
        if (runAsClient) {
            this.executionEvent.fire((Object)new LocalExecutionEvent(event.getTestMethodExecutor()));
        } else {
            this.executionEvent.fire((Object)new RemoteExecutionEvent(event.getTestMethodExecutor()));
        }
    }
}

