/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.junit.testspi;

import org.jboss.arquillian.junit.JUnitIntegrationTestCase;
import org.jboss.arquillian.spi.Configuration;
import org.jboss.arquillian.spi.ContainerMethodExecutor;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.DeployableContainer;
import org.jboss.arquillian.spi.DeploymentException;
import org.jboss.arquillian.spi.LifecycleException;
import org.jboss.arquillian.spi.TestMethodExecutor;
import org.jboss.arquillian.spi.TestResult;
import org.jboss.shrinkwrap.api.Archive;

public class TestDeployableContainer
implements DeployableContainer {
    private int numberOfTimesDeployed = 0;

    public void setup(Context context, Configuration configuration) {
        JUnitIntegrationTestCase.wasCalled("setup");
    }

    public void start(Context context) throws LifecycleException {
        JUnitIntegrationTestCase.wasCalled("start");
    }

    public void stop(Context context) throws LifecycleException {
        JUnitIntegrationTestCase.wasCalled("stop");
    }

    public ContainerMethodExecutor deploy(Context context, Archive<?> archive) throws DeploymentException {
        ++this.numberOfTimesDeployed;
        JUnitIntegrationTestCase.wasCalled("deploy");
        if (this.numberOfTimesDeployed == 1) {
            throw new RuntimeException("deploy");
        }
        return new ContainerMethodExecutor(){

            public TestResult invoke(TestMethodExecutor testMethodExecutor) {
                TestResult result = new TestResult();
                try {
                    testMethodExecutor.invoke();
                    result.setStatus(TestResult.Status.PASSED);
                }
                catch (Throwable e) {
                    result.setStatus(TestResult.Status.FAILED);
                    result.setThrowable(e);
                }
                return result;
            }
        };
    }

    public void undeploy(Context context, Archive<?> archive) throws DeploymentException {
        JUnitIntegrationTestCase.wasCalled("undeploy");
        if (this.numberOfTimesDeployed == 1) {
            throw new RuntimeException("undeploy");
        }
    }
}

