/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.junit;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.arquillian.impl.DeployableTestBuilder;
import org.jboss.arquillian.impl.XmlConfigurationBuilder;
import org.jboss.arquillian.spi.Configuration;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.TestMethodExecutor;
import org.jboss.arquillian.spi.TestResult;
import org.jboss.arquillian.spi.TestRunnerAdaptor;
import org.jboss.arquillian.spi.util.TestEnrichers;
import org.junit.internal.runners.model.MultipleFailureException;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class Arquillian
extends BlockJUnit4ClassRunner {
    public static ThreadLocal<Throwable> caughtTestException = new ThreadLocal();
    private static ThreadLocal<Arquillian> lastCreatedRunner = new ThreadLocal();
    private static ThreadLocal<TestRunnerAdaptor> deployableTest = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Arquillian(Class<?> klass) throws InitializationError {
        block6: {
            super(klass);
            try {
                if (deployableTest.get() != null) break block6;
                if (lastCreatedRunner.get() != null) {
                    throw new RuntimeException("Arquillian has previously been attempted initialized, but failed. See previous exceptions for cause.");
                }
                Configuration configuration = new XmlConfigurationBuilder().build();
                TestRunnerAdaptor adaptor = DeployableTestBuilder.build((Configuration)configuration);
                try {
                    adaptor.beforeSuite();
                    deployableTest.set(adaptor);
                }
                catch (Exception e) {
                    throw new InitializationError(Arrays.asList(e));
                }
            }
            finally {
                lastCreatedRunner.set(this);
            }
        }
    }

    public void run(RunNotifier notifier) {
        notifier.addListener(new RunListener(){

            public void testRunFinished(Result result) throws Exception {
                try {
                    if (deployableTest.get() != null && lastCreatedRunner.get() == Arquillian.this) {
                        ((TestRunnerAdaptor)deployableTest.get()).afterSuite();
                        lastCreatedRunner.set(null);
                        deployableTest.set(null);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not run @AfterSuite", e);
                }
            }
        });
        super.run(notifier);
    }

    protected List<FrameworkMethod> computeTestMethods() {
        return super.computeTestMethods();
    }

    protected void validatePublicVoidNoArgMethods(Class<? extends Annotation> annotation, boolean isStatic, List<Throwable> errors) {
        List methods = this.getTestClass().getAnnotatedMethods(annotation);
        for (FrameworkMethod eachTestMethod : methods) {
            eachTestMethod.validatePublicVoid(isStatic, errors);
        }
    }

    protected Statement withBeforeClasses(Statement originalStatement) {
        final Statement statementWithBefores = super.withBeforeClasses(originalStatement);
        return new Statement(){

            public void evaluate() throws Throwable {
                TestClass testClass = Arquillian.this.getTestClass();
                TestRunnerAdaptor testRunnerAdaptor = (TestRunnerAdaptor)deployableTest.get();
                testRunnerAdaptor.beforeClass(testClass.getJavaClass());
                statementWithBefores.evaluate();
            }
        };
    }

    protected Statement withAfterClasses(Statement originalStatement) {
        final Statement statementWithAfters = super.withAfterClasses(originalStatement);
        return new Statement(){

            public void evaluate() throws Throwable {
                new MultiStatementExecutor().execute(new Statement(){

                    public void evaluate() throws Throwable {
                        statementWithAfters.evaluate();
                    }
                }, new Statement(){

                    public void evaluate() throws Throwable {
                        ((TestRunnerAdaptor)deployableTest.get()).afterClass(Arquillian.this.getTestClass().getJavaClass());
                    }
                });
            }
        };
    }

    protected Statement withBefores(final FrameworkMethod method, final Object target, Statement originalStatement) {
        final Statement statementWithBefores = super.withBefores(method, target, originalStatement);
        return new Statement(){

            public void evaluate() throws Throwable {
                ((TestRunnerAdaptor)deployableTest.get()).before(target, method.getMethod());
                statementWithBefores.evaluate();
            }
        };
    }

    protected Statement withAfters(final FrameworkMethod method, final Object target, Statement originalStatement) {
        final Statement statementWithAfters = super.withAfters(method, target, originalStatement);
        return new Statement(){

            public void evaluate() throws Throwable {
                new MultiStatementExecutor().execute(new Statement(){

                    public void evaluate() throws Throwable {
                        statementWithAfters.evaluate();
                    }
                }, new Statement(){

                    public void evaluate() throws Throwable {
                        ((TestRunnerAdaptor)deployableTest.get()).after(target, method.getMethod());
                    }
                });
            }
        };
    }

    protected Statement methodInvoker(final FrameworkMethod method, final Object test) {
        return new Statement(){

            public void evaluate() throws Throwable {
                TestResult result = ((TestRunnerAdaptor)deployableTest.get()).test(new TestMethodExecutor(){

                    public void invoke() throws Throwable {
                        try {
                            Object[] parameterValues = TestEnrichers.enrich((Context)((TestRunnerAdaptor)deployableTest.get()).getActiveContext(), (Method)this.getMethod());
                            method.invokeExplosively(test, parameterValues);
                        }
                        catch (Throwable e) {
                            caughtTestException.set(e);
                            throw e;
                        }
                    }

                    public Method getMethod() {
                        return method.getMethod();
                    }

                    public Object getInstance() {
                        return test;
                    }
                });
                if (result.getThrowable() != null) {
                    throw result.getThrowable();
                }
            }
        };
    }

    private class MultiStatementExecutor {
        private MultiStatementExecutor() {
        }

        public void execute(Statement ... statements) throws Throwable {
            ArrayList<Exception> exceptions = new ArrayList<Exception>();
            for (Statement command : statements) {
                try {
                    command.evaluate();
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
            if (exceptions.isEmpty()) {
                return;
            }
            if (exceptions.size() == 1) {
                throw (Throwable)exceptions.get(0);
            }
            throw new MultipleFailureException(exceptions);
        }
    }
}

