/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spi.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DefaultServiceLoader<S>
implements Iterable<S> {
    private static final String SERVICES = "META-INF/services";
    private final String serviceFile;
    private Class<S> expectedType;
    private final ClassLoader loader;
    private Set<S> providers;

    public static <S> DefaultServiceLoader<S> load(Class<S> service) {
        return DefaultServiceLoader.load(SERVICES, service, Thread.currentThread().getContextClassLoader());
    }

    public static <S> DefaultServiceLoader<S> load(String directoryName, Class<S> service) {
        return DefaultServiceLoader.load(directoryName, service, Thread.currentThread().getContextClassLoader());
    }

    public static <S> DefaultServiceLoader<S> load(String directoryName, Class<S> service, ClassLoader loader) {
        if (loader == null) {
            loader = service.getClassLoader();
        }
        return new DefaultServiceLoader<S>(directoryName, service, loader);
    }

    public static <S> DefaultServiceLoader<S> load(Class<S> service, ClassLoader loader) {
        return DefaultServiceLoader.load(SERVICES, service, loader);
    }

    public static <S> DefaultServiceLoader<S> loadInstalled(Class<S> service) {
        throw new UnsupportedOperationException();
    }

    private DefaultServiceLoader(String prefix, Class<S> service, ClassLoader loader) {
        this.loader = loader;
        this.serviceFile = prefix + "/" + service.getName();
        this.expectedType = service;
    }

    public void reload() {
        this.providers = new HashSet<S>();
        Enumeration<URL> enumeration = null;
        boolean errorOccurred = false;
        try {
            enumeration = this.loader.getResources(this.serviceFile);
        }
        catch (IOException ioe) {
            errorOccurred = true;
        }
        if (!errorOccurred) {
            while (enumeration.hasMoreElements()) {
                try {
                    URL url = enumeration.nextElement();
                    InputStream is = url.openStream();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    String line = reader.readLine();
                    while (null != line) {
                        block17: {
                            try {
                                int comment = line.indexOf(35);
                                if (comment > -1) {
                                    line = line.substring(0, comment);
                                }
                                line.trim();
                                if (line.length() <= 0) break block17;
                                try {
                                    Class<S> serviceClass;
                                    Class<?> clazz = this.loader.loadClass(line);
                                    try {
                                        serviceClass = clazz.asSubclass(this.expectedType);
                                    }
                                    catch (ClassCastException e) {
                                        throw new IllegalStateException("Extension " + line + " does not implement Extension");
                                    }
                                    Constructor<S> constructor = serviceClass.getConstructor(new Class[0]);
                                    if (!constructor.isAccessible()) {
                                        constructor.setAccessible(true);
                                    }
                                    S instance = constructor.newInstance(new Object[0]);
                                    this.providers.add(instance);
                                }
                                catch (NoClassDefFoundError e) {
                                    throw e;
                                }
                                catch (InstantiationException e) {
                                    throw e;
                                }
                                catch (IllegalAccessException e) {
                                    throw e;
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        line = reader.readLine();
                    }
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public Iterator<S> iterator() {
        if (this.providers == null) {
            this.reload();
        }
        return this.providers.iterator();
    }

    public Set<S> getProviders() {
        if (this.providers == null) {
            this.reload();
        }
        return Collections.unmodifiableSet(this.providers);
    }

    public String toString() {
        return "Services for " + this.serviceFile;
    }
}

