/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testng;

import java.util.ArrayList;
import java.util.Arrays;
import org.jboss.arquillian.impl.DeployableTestBuilder;
import org.jboss.arquillian.spi.ContainerProfile;
import org.jboss.arquillian.spi.TestResult;
import org.jboss.arquillian.spi.TestRunner;
import org.jboss.arquillian.testng.TestListener;
import org.testng.ITestListener;
import org.testng.TestNG;
import org.testng.internal.AnnotationTypeEnum;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNGTestRunner
implements TestRunner {
    public TestResult execute(Class<?> testClass, String methodName) {
        DeployableTestBuilder.setProfile((ContainerProfile)ContainerProfile.CONTAINER);
        TestListener resultListener = new TestListener();
        TestNG runner = new TestNG(true);
        runner.setVerbose(0);
        runner.addListener((ITestListener)resultListener);
        runner.setXmlSuites(Arrays.asList(this.createSuite(testClass, methodName)));
        runner.run();
        return resultListener.getTestResult();
    }

    private XmlSuite createSuite(Class<?> className, String methodName) {
        XmlSuite suite = new XmlSuite();
        suite.setName("Arquillian");
        suite.setAnnotations(AnnotationTypeEnum.JDK.getName());
        XmlTest test = new XmlTest(suite);
        test.setName("Arquillian - " + className);
        ArrayList<XmlClass> testClasses = new ArrayList<XmlClass>();
        XmlClass testClass = new XmlClass(className);
        testClass.getIncludedMethods().add(methodName);
        testClasses.add(testClass);
        test.setXmlClasses(testClasses);
        return suite;
    }
}

