/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testng;

import java.lang.reflect.Method;
import org.jboss.arquillian.impl.DeployableTestBuilder;
import org.jboss.arquillian.impl.XmlConfigurationBuilder;
import org.jboss.arquillian.spi.Configuration;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.TestMethodExecutor;
import org.jboss.arquillian.spi.TestResult;
import org.jboss.arquillian.spi.TestRunnerAdaptor;
import org.jboss.arquillian.spi.util.TestEnrichers;
import org.testng.IHookCallBack;
import org.testng.IHookable;
import org.testng.ITestResult;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.DataProvider;

public abstract class Arquillian
implements IHookable {
    public static final String ARQUILLIAN_DATA_PROVIDER = "ARQUILLIAN_DATA_PROVIDER";
    private static ThreadLocal<TestRunnerAdaptor> deployableTest = new ThreadLocal();

    @BeforeSuite(alwaysRun=true)
    public void arquillianBeforeSuite() throws Exception {
        if (deployableTest.get() == null) {
            Configuration configuration = new XmlConfigurationBuilder().build();
            TestRunnerAdaptor adaptor = DeployableTestBuilder.build((Configuration)configuration);
            adaptor.beforeSuite();
            deployableTest.set(adaptor);
        }
    }

    @AfterSuite(alwaysRun=true)
    public void arquillianAfterSuite() throws Exception {
        if (deployableTest.get() == null) {
            return;
        }
        deployableTest.get().afterSuite();
        deployableTest.set(null);
    }

    @BeforeClass(alwaysRun=true)
    public void arquillianBeforeClass() throws Exception {
        deployableTest.get().beforeClass(this.getClass());
    }

    @AfterClass(alwaysRun=true)
    public void arquillianAfterClass() throws Exception {
        deployableTest.get().afterClass(this.getClass());
    }

    @BeforeMethod(alwaysRun=true)
    public void arquillianBeforeTest(Method testMethod) throws Exception {
        deployableTest.get().before((Object)this, testMethod);
    }

    @AfterMethod(alwaysRun=true)
    public void arquillianAfterTest(Method testMethod) throws Exception {
        deployableTest.get().after((Object)this, testMethod);
    }

    public void run(final IHookCallBack callback, final ITestResult testResult) {
        try {
            TestResult result = deployableTest.get().test(new TestMethodExecutor(){

                public void invoke() throws Throwable {
                    callback.runTestMethod(testResult);
                    this.clearParameters(testResult);
                }

                private void clearParameters(ITestResult testResult2) {
                    Object[] parameters = testResult2.getParameters();
                    for (int i = 0; parameters != null && i < parameters.length; ++i) {
                        Object parameter = parameters[i];
                        parameters[i] = parameter != null ? parameter.getClass().getName() : "null";
                    }
                }

                public Method getMethod() {
                    return testResult.getMethod().getMethod();
                }

                public Object getInstance() {
                    return Arquillian.this;
                }
            });
            if (result.getThrowable() != null) {
                testResult.setThrowable(result.getThrowable());
            }
            testResult.setEndMillis(result.getStart() - result.getEnd() + testResult.getStartMillis());
        }
        catch (Exception e) {
            testResult.setThrowable((Throwable)e);
        }
    }

    @DataProvider(name="ARQUILLIAN_DATA_PROVIDER")
    public Object[][] arquillianArgumentProvider(Method method) {
        Object[][] values = new Object[1][method.getParameterTypes().length];
        if (deployableTest.get() == null) {
            return values;
        }
        Object[] parameterValues = TestEnrichers.enrich((Context)deployableTest.get().getActiveContext(), (Method)method);
        values[0] = parameterValues;
        return values;
    }
}

