/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.config.impl.extension;

import java.io.OutputStream;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ContainerDef;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.jboss.arquillian.config.descriptor.api.GroupDef;
import org.jboss.arquillian.config.descriptor.api.ProtocolDef;
import org.jboss.arquillian.config.impl.extension.PropertiesParser;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PropertiesParserTestCase {
    private static final String ENGINE_PROP_DEPLOYMENTS = "arq.engine.deploymentExportPath";
    private static final String ENGINE_PROP_MAXCLASS = "arq.engine.maxTestClassesBeforeRestart";
    private static final String ENGINE_VAL_DEPLOYMENTS = "target";
    private static final String ENGINE_VAL_MAXCLASSES = "2";
    private static final String CONFIGURATION_PROP_1 = "jbossHome";
    private static final String CONTAINER_PROP_CONFIGURATION_1 = "arq.container.jboss.configuration.jbossHome";
    private static final String CONTAINER_VAL_CONFIGURATION_1 = "target/jboss-as";
    private static final String CONTAINER_PROP_PROTOCOL_1 = "arq.container.jboss.protocol.Servlet 3.0.jbossHome";
    private static final String CONTAINER_VAL_PROTOCOL_1 = "192.0.0.1";
    private static final String CONTAINER_PROP_1 = "arq.container.jboss.mode";
    private static final String CONTAINER_VAL_1 = "suite";
    private static final String GROUP_PROP_CONTAINER_CONFIGURATION_1 = "arq.group.cluster.container.jboss.configuration.jbossHome";
    private static final String GROUP_VAL_CONTAINER_CONFIGURATION_1 = "suite";
    private static final String GROUP_PROP_CONTAINER_PROTOCOL_1 = "arq.group.Cluster 1.container.JBoss AS 7.protocol.Servlet 3.0.jbossHome";
    private static final String GROUP_VAL_CONTAINER_PROTOCOL_1 = "suite";
    private static final String GROUP_PROP_CONTAINER_1 = "arq.group.cluster.container.jboss.mode";
    private static final String GROUP_VAL_CONTAINER_1 = "suite";
    private static final String GROUP_PROP_1 = "arq.group.cluster.default";
    private static final String GROUP_VAL_1 = "true";
    private static final String DEFAULT_PROTOCOL_PROP_1 = "arq.defaultprotocol.Servlet 3.0.jbossHome";
    private static final String DEFAULT_PROTOCOL_VAL_1 = "true";
    private static final String EXTENSION_PROP_1 = "arq.extension.extension-1.jbossHome";
    private static final String EXTENSION_VAL_1 = "suite";
    private ArquillianDescriptor desc;

    @Before
    public void createDescriptor() {
        this.desc = this.create();
    }

    @After
    public void print() {
        this.desc.exportTo((OutputStream)System.out);
    }

    @Test
    public void shouldBeAbleToSetEngineProperties() {
        this.validate(ENGINE_PROP_DEPLOYMENTS, ENGINE_VAL_DEPLOYMENTS, new ValueCallback(){

            public String get() {
                return PropertiesParserTestCase.this.desc.engine().getDeploymentExportPath();
            }
        });
        this.validate(ENGINE_PROP_MAXCLASS, ENGINE_VAL_MAXCLASSES, new ValueCallback(){

            public String get() {
                return String.valueOf(PropertiesParserTestCase.this.desc.engine().getMaxTestClassesBeforeRestart());
            }
        });
    }

    @Test
    public void shouldBeAbleToAddContainer() {
        this.validate(CONTAINER_PROP_1, "suite", new ValueCallback(){

            public String get() {
                return ((ContainerDef)PropertiesParserTestCase.this.desc.getContainers().get(0)).getMode();
            }
        });
    }

    @Test
    public void shouldBeAbleToAddContainerConfiguration() {
        this.validate(CONTAINER_PROP_CONFIGURATION_1, CONTAINER_VAL_CONFIGURATION_1, new ValueCallback(){

            public String get() {
                return (String)((ContainerDef)PropertiesParserTestCase.this.desc.getContainers().get(0)).getContainerProperties().get(PropertiesParserTestCase.CONFIGURATION_PROP_1);
            }
        });
    }

    @Test
    public void shouldBeAbleToAddContainerProtocol() {
        this.validate(CONTAINER_PROP_PROTOCOL_1, CONTAINER_VAL_PROTOCOL_1, new ValueCallback(){

            public String get() {
                return (String)((ProtocolDef)((ContainerDef)PropertiesParserTestCase.this.desc.getContainers().get(0)).getProtocols().get(0)).getProtocolProperties().get(PropertiesParserTestCase.CONFIGURATION_PROP_1);
            }
        });
    }

    @Test
    public void shouldBeAbleToAddGroup() {
        this.validate(GROUP_PROP_1, "true", new ValueCallback(){

            public String get() {
                return String.valueOf(((GroupDef)PropertiesParserTestCase.this.desc.getGroups().get(0)).isGroupDefault());
            }
        });
    }

    @Test
    public void shouldBeAbleToAddGroupContianer() {
        this.validate(GROUP_PROP_CONTAINER_1, "suite", new ValueCallback(){

            public String get() {
                return ((ContainerDef)((GroupDef)PropertiesParserTestCase.this.desc.getGroups().get(0)).getGroupContainers().get(0)).getMode();
            }
        });
    }

    @Test
    public void shouldBeAbleToAddGroupContianerConfiguration() {
        this.validate(GROUP_PROP_CONTAINER_CONFIGURATION_1, "suite", new ValueCallback(){

            public String get() {
                return (String)((ContainerDef)((GroupDef)PropertiesParserTestCase.this.desc.getGroups().get(0)).getGroupContainers().get(0)).getContainerProperties().get(PropertiesParserTestCase.CONFIGURATION_PROP_1);
            }
        });
    }

    @Test
    public void shouldBeAbleToAddGroupContianerProtocol() {
        this.validate(GROUP_PROP_CONTAINER_PROTOCOL_1, "suite", new ValueCallback(){

            public String get() {
                return (String)((ProtocolDef)((ContainerDef)((GroupDef)PropertiesParserTestCase.this.desc.getGroups().get(0)).getGroupContainers().get(0)).getProtocols().get(0)).getProtocolProperties().get(PropertiesParserTestCase.CONFIGURATION_PROP_1);
            }
        });
    }

    @Test
    public void shouldBeAbleToAddDefaultProtocol() {
        this.validate(DEFAULT_PROTOCOL_PROP_1, "true", new ValueCallback(){

            public String get() {
                return (String)PropertiesParserTestCase.this.desc.getDefaultProtocol().getProperties().get(PropertiesParserTestCase.CONFIGURATION_PROP_1);
            }
        });
    }

    @Test
    public void shouldBeAbleToAddExtension() {
        this.validate(EXTENSION_PROP_1, "suite", new ValueCallback(){

            public String get() {
                return (String)((ExtensionDef)PropertiesParserTestCase.this.desc.getExtensions().get(0)).getExtensionProperties().get(PropertiesParserTestCase.CONFIGURATION_PROP_1);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validate(String property, String value, ValueCallback callback) {
        try {
            System.setProperty(property, value);
            new PropertiesParser().addProperties(this.desc, System.getProperties());
            Assert.assertEquals((Object)value, (Object)callback.get());
        }
        finally {
            System.clearProperty(property);
        }
    }

    private ArquillianDescriptor create() {
        return (ArquillianDescriptor)Descriptors.create(ArquillianDescriptor.class);
    }

    public static interface ValueCallback {
        public String get();
    }
}

