/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.config.impl.extension;

import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ContainerDef;
import org.jboss.arquillian.config.impl.extension.ConfigurationRegistrar;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.event.ManagerStarted;
import org.jboss.arquillian.core.test.AbstractManagerTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConfigurationRegistrarTestCase
extends AbstractManagerTestBase {
    @Inject
    private Instance<Injector> injectorInst;
    @Inject
    private Instance<ArquillianDescriptor> descInst;
    private ConfigurationRegistrar registrar;

    @Before
    public void injectConfigurationRegistrar() {
        this.registrar = (ConfigurationRegistrar)((Injector)this.injectorInst.get()).inject((Object)new ConfigurationRegistrar());
    }

    @Test
    public void shouldBeAbleToLoadEmptyDefaultConfiguration() throws Exception {
        this.registrar.loadConfiguration(new ManagerStarted());
        ArquillianDescriptor desc = (ArquillianDescriptor)this.descInst.get();
        Assert.assertEquals((long)0L, (long)desc.getContainers().size());
        Assert.assertEquals((long)0L, (long)desc.getGroups().size());
        Assert.assertEquals((long)0L, (long)desc.getExtensions().size());
    }

    @Test
    public void shouldBeAbleToLoadConfiguredXMLFileResource() throws Exception {
        ConfigurationRegistrarTestCase.validate("arquillian.xml", "src/test/resources/registrar_tests/named_arquillian.xml", new AssertCallback(){

            public void validate() {
                ConfigurationRegistrarTestCase.this.registrar.loadConfiguration(new ManagerStarted());
                ArquillianDescriptor desc = (ArquillianDescriptor)ConfigurationRegistrarTestCase.this.descInst.get();
                Assert.assertEquals((long)1L, (long)desc.getContainers().size());
                Assert.assertEquals((Object)"A", (Object)((ContainerDef)desc.getContainers().get(0)).getContainerName());
                Assert.assertEquals((Object)"class", (Object)((ContainerDef)desc.getContainers().get(0)).getMode());
            }
        });
    }

    @Test
    public void shouldBeAbleToLoadConfiguredXMLClasspathResource() throws Exception {
        ConfigurationRegistrarTestCase.validate("arquillian.xml", "registrar_tests/named_arquillian.xml", new AssertCallback(){

            public void validate() {
                ConfigurationRegistrarTestCase.this.registrar.loadConfiguration(new ManagerStarted());
                ArquillianDescriptor desc = (ArquillianDescriptor)ConfigurationRegistrarTestCase.this.descInst.get();
                Assert.assertEquals((long)1L, (long)desc.getContainers().size());
                Assert.assertEquals((Object)"A", (Object)((ContainerDef)desc.getContainers().get(0)).getContainerName());
                Assert.assertEquals((Object)"class", (Object)((ContainerDef)desc.getContainers().get(0)).getMode());
            }
        });
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionOnMissingConfiguredXMLResource() throws Exception {
        ConfigurationRegistrarTestCase.validate("arquillian.xml", "registrar_tests/named_arquillian_SHOULD_NOT_BE_FOUND_.xml", new AssertCallback(){

            public void validate() {
                ConfigurationRegistrarTestCase.this.registrar.loadConfiguration(new ManagerStarted());
            }
        });
    }

    @Test
    public void shouldBeAbleToLoadConfiguredPropertiesFileResource() throws Exception {
        ConfigurationRegistrarTestCase.validate("arquillian.properties", "src/test/resources/registrar_tests/named_arquillian.properties", new AssertCallback(){

            public void validate() {
                ConfigurationRegistrarTestCase.this.registrar.loadConfiguration(new ManagerStarted());
                ArquillianDescriptor desc = (ArquillianDescriptor)ConfigurationRegistrarTestCase.this.descInst.get();
                Assert.assertEquals((long)1L, (long)desc.getContainers().size());
                Assert.assertEquals((Object)"B", (Object)((ContainerDef)desc.getContainers().get(0)).getContainerName());
            }
        });
    }

    @Test
    public void shouldBeAbleToLoadConfiguredPropertiesClasspathResource() throws Exception {
        ConfigurationRegistrarTestCase.validate("arquillian.properties", "registrar_tests/named_arquillian.properties", new AssertCallback(){

            public void validate() {
                ConfigurationRegistrarTestCase.this.registrar.loadConfiguration(new ManagerStarted());
                ArquillianDescriptor desc = (ArquillianDescriptor)ConfigurationRegistrarTestCase.this.descInst.get();
                Assert.assertEquals((long)1L, (long)desc.getContainers().size());
                Assert.assertEquals((Object)"B", (Object)((ContainerDef)desc.getContainers().get(0)).getContainerName());
                Assert.assertEquals((Object)"manual", (Object)((ContainerDef)desc.getContainers().get(0)).getMode());
            }
        });
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionOnMissingConfiguredPropertiesResource() throws Exception {
        ConfigurationRegistrarTestCase.validate("arquillian.properties", "registrar_tests/named_arquillian_SHOULD_NOT_BE_FOUND_.properties", new AssertCallback(){

            public void validate() {
                ConfigurationRegistrarTestCase.this.registrar.loadConfiguration(new ManagerStarted());
            }
        });
    }

    @Test
    public void shouldBeAbleToAddSystemProperties() throws Exception {
        ConfigurationRegistrarTestCase.validate("arq.container.C.mode", "manual", new AssertCallback(){

            public void validate() {
                ConfigurationRegistrarTestCase.this.registrar.loadConfiguration(new ManagerStarted());
                ArquillianDescriptor desc = (ArquillianDescriptor)ConfigurationRegistrarTestCase.this.descInst.get();
                Assert.assertEquals((long)1L, (long)desc.getContainers().size());
                Assert.assertEquals((Object)"C", (Object)((ContainerDef)desc.getContainers().get(0)).getContainerName());
                Assert.assertEquals((Object)"manual", (Object)((ContainerDef)desc.getContainers().get(0)).getMode());
            }
        });
    }

    @Test
    public void shouldBeAbleToOverrideWithSystemProperties() throws Exception {
        ConfigurationRegistrarTestCase.validate("arquillian.xml", "registrar_tests/named_arquillian.xml", new AssertCallback(){

            public void validate() {
                ConfigurationRegistrarTestCase.validate("arq.container.A.mode", "suite", new AssertCallback(){

                    public void validate() {
                        ConfigurationRegistrarTestCase.this.registrar.loadConfiguration(new ManagerStarted());
                        ArquillianDescriptor desc = (ArquillianDescriptor)ConfigurationRegistrarTestCase.this.descInst.get();
                        Assert.assertEquals((long)1L, (long)desc.getContainers().size());
                        Assert.assertEquals((Object)"A", (Object)((ContainerDef)desc.getContainers().get(0)).getContainerName());
                        Assert.assertEquals((Object)"suite", (Object)((ContainerDef)desc.getContainers().get(0)).getMode());
                    }
                });
            }
        });
    }

    @Test
    public void shouldBeAbleToAddToXMLWithProperties() throws Exception {
        ConfigurationRegistrarTestCase.validate("arquillian.xml", "registrar_tests/named_arquillian.xml", new AssertCallback(){

            public void validate() {
                ConfigurationRegistrarTestCase.validate("arquillian.properties", "registrar_tests/named_arquillian.properties", new AssertCallback(){

                    public void validate() {
                        ConfigurationRegistrarTestCase.this.registrar.loadConfiguration(new ManagerStarted());
                        ArquillianDescriptor desc = (ArquillianDescriptor)ConfigurationRegistrarTestCase.this.descInst.get();
                        Assert.assertEquals((long)2L, (long)desc.getContainers().size());
                        Assert.assertEquals((Object)"A", (Object)((ContainerDef)desc.getContainers().get(0)).getContainerName());
                        Assert.assertEquals((Object)"B", (Object)((ContainerDef)desc.getContainers().get(1)).getContainerName());
                    }
                });
            }
        });
    }

    @Test
    public void shouldBeAbleToOverrideToXMLWithProperties() throws Exception {
        ConfigurationRegistrarTestCase.validate("arquillian.xml", "registrar_tests/named_arquillian.xml", new AssertCallback(){

            public void validate() {
                ConfigurationRegistrarTestCase.validate("arquillian.properties", "registrar_tests/override_named_arquillian.properties", new AssertCallback(){

                    public void validate() {
                        ConfigurationRegistrarTestCase.this.registrar.loadConfiguration(new ManagerStarted());
                        ArquillianDescriptor desc = (ArquillianDescriptor)ConfigurationRegistrarTestCase.this.descInst.get();
                        Assert.assertEquals((long)1L, (long)desc.getContainers().size());
                        Assert.assertEquals((Object)"A", (Object)((ContainerDef)desc.getContainers().get(0)).getContainerName());
                        Assert.assertEquals((Object)"suite", (Object)((ContainerDef)desc.getContainers().get(0)).getMode());
                    }
                });
            }
        });
    }

    static void validate(String property, String value, AssertCallback callback) {
        try {
            System.setProperty(property, value);
            callback.validate();
        }
        finally {
            System.clearProperty(property);
        }
    }

    public static interface AssertCallback {
        public void validate();
    }
}

