/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.config.descriptor.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ContainerDef;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.jboss.arquillian.config.descriptor.api.GroupDef;
import org.jboss.arquillian.config.descriptor.api.ProtocolDef;
import org.jboss.arquillian.config.descriptor.impl.AssertXPath;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ArquillianDescriptorTestCase {
    private static final String CONTAINER_NAME_1 = "jbossas-remote";
    private static final String CONTAINER_NAME_2 = "jbossas-embedded";
    private static final String CONTAINER_NAME_3 = "jbossas-managed";
    private static final String CONTAINER_NAME_4 = "jbossas-cloud";
    private static final String PROTOCOL_TYPE_1 = "Servlet 3.0";
    private static final String PROTOCOL_TYPE_2 = "Servlet 2.5";
    private static final String PROTOCOL_TYPE_3 = "EJB 3.0";
    private static final String GROUP_NAME_1 = "jbossas-remote-group";
    private static final String GROUP_NAME_2 = "jbossas-embedded-group";
    private static final String DEPENDENCY_1 = "org.test:test";
    private static final String DEPENDENCY_2 = "org.test:test2";
    private static final String EXTENSION_NAME_1 = "selenium";
    private static final String EXTENSION_NAME_2 = "performance";
    private static final String PROPERTY_NAME_1 = "test-name";
    private static final String PROPERTY_VALUE_1 = "test-value";
    private static final String PROPERTY_NAME_2 = "test2-name";
    private static final String PROPERTY_VALUE_2 = "test2-value";
    private static final String PROPERTY_NAME_3 = "test3-name";
    private static final String PROPERTY_VALUE_3 = "test3-value";
    private static final Integer PROPERTY_INT_VALUE_1 = 10;
    private String desc;

    @After
    public void print() {
        System.out.println(this.desc);
    }

    @Test
    public void shouldBeAbleToGenerateEmpty() throws Exception {
        this.desc = this.create().exportAsString();
    }

    @Test
    public void shouldBeAbleToSetEngineProperties() throws Exception {
        this.desc = this.create().engine().deploymentExportPath(PROPERTY_VALUE_1).deploymentExportPath(PROPERTY_VALUE_1).maxTestClassesBeforeRestart(PROPERTY_INT_VALUE_1).maxTestClassesBeforeRestart(PROPERTY_INT_VALUE_1).exportAsString();
        AssertXPath.assertXPath(this.desc, "/arquillian/engine/property[@name='deploymentExportPath']/text()", PROPERTY_VALUE_1);
        AssertXPath.assertXPath(this.desc, "/arquillian/engine/property[@name='maxTestClassesBeforeRestart']/text()", PROPERTY_INT_VALUE_1);
        ArquillianDescriptor descriptor = this.create(this.desc);
        Assert.assertEquals((Object)PROPERTY_VALUE_1, (Object)descriptor.engine().getDeploymentExportPath());
        Assert.assertEquals((Object)PROPERTY_INT_VALUE_1, (Object)descriptor.engine().getMaxTestClassesBeforeRestart());
    }

    @Test
    public void shouldReturnNullOnEnginePropertiesIfNotSet() throws Exception {
        this.desc = this.create().engine().exportAsString();
        ArquillianDescriptor descriptor = this.create(this.desc);
        Assert.assertNull((Object)descriptor.engine().getDeploymentExportPath());
        Assert.assertNull((Object)descriptor.engine().getMaxTestClassesBeforeRestart());
    }

    @Test
    public void shouldBeAbleToAddContainer() throws Exception {
        this.desc = this.create().container(CONTAINER_NAME_1).setDefault().container(CONTAINER_NAME_2).exportAsString();
        AssertXPath.assertXPath(this.desc, "/arquillian/container/@qualifier", CONTAINER_NAME_1, CONTAINER_NAME_2);
        AssertXPath.assertXPath(this.desc, "/arquillian/container[1]/@default", "true");
        ArquillianDescriptor descriptor = this.create(this.desc);
        Assert.assertEquals((long)2L, (long)descriptor.getContainers().size());
        Assert.assertEquals((Object)CONTAINER_NAME_1, (Object)((ContainerDef)descriptor.getContainers().get(0)).getContainerName());
        Assert.assertTrue((boolean)((ContainerDef)descriptor.getContainers().get(0)).isDefault());
        Assert.assertEquals((Object)CONTAINER_NAME_2, (Object)((ContainerDef)descriptor.getContainers().get(1)).getContainerName());
    }

    @Test
    public void shouldBeAbleToAddContainerAndOverwrite() throws Exception {
        this.desc = this.create().container(CONTAINER_NAME_1).setDefault().container(CONTAINER_NAME_1).setContainerName(CONTAINER_NAME_2).exportAsString();
        AssertXPath.assertXPath(this.desc, "/arquillian/container/@qualifier", CONTAINER_NAME_2);
        AssertXPath.assertXPath(this.desc, "/arquillian/container/@default", "true");
        ArquillianDescriptor descriptor = this.create(this.desc);
        Assert.assertEquals((long)1L, (long)descriptor.getContainers().size());
        Assert.assertEquals((Object)CONTAINER_NAME_2, (Object)((ContainerDef)descriptor.getContainers().get(0)).getContainerName());
        Assert.assertTrue((boolean)((ContainerDef)descriptor.getContainers().get(0)).isDefault());
    }

    @Test
    public void shouldBeAbleToAddDefaultProtocol() throws Exception {
        this.desc = this.create().defaultProtocol(PROTOCOL_TYPE_1).property(PROPERTY_NAME_1, PROPERTY_VALUE_1).exportAsString();
        AssertXPath.assertXPath(this.desc, "/arquillian/defaultProtocol/@type", PROTOCOL_TYPE_1);
        AssertXPath.assertXPath(this.desc, "/arquillian/defaultProtocol/property/@name", PROPERTY_NAME_1);
        AssertXPath.assertXPath(this.desc, "/arquillian/defaultProtocol/property/text()", PROPERTY_VALUE_1);
        ArquillianDescriptor descriptor = this.create(this.desc);
        Assert.assertNotNull((Object)descriptor.getDefaultProtocol());
        Assert.assertEquals((Object)PROTOCOL_TYPE_1, (Object)descriptor.getDefaultProtocol().getType());
        Assert.assertEquals((Object)PROPERTY_VALUE_1, descriptor.getDefaultProtocol().getProperties().get(PROPERTY_NAME_1));
    }

    @Test
    public void shouldReturnNullDefaultProtocolIfNotAdded() throws Exception {
        this.desc = this.create().exportAsString();
        ArquillianDescriptor descriptor = this.create(this.desc);
        Assert.assertNull((Object)descriptor.getDefaultProtocol());
    }

    @Test
    public void shouldBeAbleToAddDefaultProtocolAndOverwriteProperty() throws Exception {
        this.desc = this.create().defaultProtocol(PROTOCOL_TYPE_1).property(PROPERTY_NAME_1, PROPERTY_VALUE_1).property(PROPERTY_NAME_1, PROPERTY_VALUE_2).exportAsString();
        AssertXPath.assertXPath(this.desc, "/arquillian/defaultProtocol/@type", PROTOCOL_TYPE_1);
        AssertXPath.assertXPath(this.desc, "/arquillian/defaultProtocol/property/@name", PROPERTY_NAME_1);
        AssertXPath.assertXPath(this.desc, "/arquillian/defaultProtocol/property/text()", PROPERTY_VALUE_2);
        ArquillianDescriptor descriptor = this.create(this.desc);
        Assert.assertNotNull((Object)descriptor.getDefaultProtocol());
        Assert.assertEquals((Object)PROTOCOL_TYPE_1, (Object)descriptor.getDefaultProtocol().getType());
        Assert.assertEquals((long)1L, (long)descriptor.getDefaultProtocol().getProperties().size());
        Assert.assertEquals((Object)PROPERTY_VALUE_2, descriptor.getDefaultProtocol().getProperties().get(PROPERTY_NAME_1));
    }

    @Test
    @Ignore
    public void shouldBeAbleToAddContainerWithDependencies() throws Exception {
        this.desc = this.create().container(CONTAINER_NAME_1).dependency(DEPENDENCY_1).dependency(DEPENDENCY_2).exportAsString();
        AssertXPath.assertXPath(this.desc, "/arquillian/container/dependencies/dependency", DEPENDENCY_1, DEPENDENCY_2);
        ArquillianDescriptor descriptor = this.create(this.desc);
        Assert.assertEquals((long)1L, (long)descriptor.getContainers().size());
        Assert.assertEquals((Object)CONTAINER_NAME_1, (Object)((ContainerDef)descriptor.getContainers().get(0)).getContainerName());
        Assert.assertEquals((Object)DEPENDENCY_1, ((ContainerDef)descriptor.getContainers().get(0)).getDependencies().get(0));
        Assert.assertEquals((Object)DEPENDENCY_2, ((ContainerDef)descriptor.getContainers().get(0)).getDependencies().get(1));
    }

    @Test
    @Ignore
    public void shouldBeAbleToAddContainerWithDependenciesAndOverwrite() throws Exception {
        this.desc = this.create().container(CONTAINER_NAME_1).dependency(DEPENDENCY_1).dependency(DEPENDENCY_1).exportAsString();
        AssertXPath.assertXPath(this.desc, "/arquillian/container/dependencies/dependency", DEPENDENCY_1);
        ArquillianDescriptor descriptor = this.create(this.desc);
        Assert.assertEquals((long)1L, (long)descriptor.getContainers().size());
        Assert.assertEquals((Object)CONTAINER_NAME_1, (Object)((ContainerDef)descriptor.getContainers().get(0)).getContainerName());
        Assert.assertEquals((long)1L, (long)((ContainerDef)descriptor.getContainers().get(0)).getDependencies().size());
        Assert.assertEquals((Object)DEPENDENCY_1, ((ContainerDef)descriptor.getContainers().get(0)).getDependencies().get(0));
    }

    @Test
    public void shouldBeAbleToAddContainerWithMultipleProtocols() throws Exception {
        this.desc = this.create().container(CONTAINER_NAME_1).protocol(PROTOCOL_TYPE_1).property(PROPERTY_NAME_1, PROPERTY_VALUE_1).protocol(PROTOCOL_TYPE_2).property(PROPERTY_NAME_2, PROPERTY_VALUE_2).exportAsString();
        AssertXPath.assertXPath(this.desc, "/arquillian/container/@qualifier", CONTAINER_NAME_1);
        AssertXPath.assertXPath(this.desc, "/arquillian/container/protocol[1]/@type", PROTOCOL_TYPE_1);
        AssertXPath.assertXPath(this.desc, "/arquillian/container/protocol[1]/property/@name", PROPERTY_NAME_1);
        AssertXPath.assertXPath(this.desc, "/arquillian/container/protocol[1]/property/text()", PROPERTY_VALUE_1);
        AssertXPath.assertXPath(this.desc, "/arquillian/container/protocol[2]/@type", PROTOCOL_TYPE_2);
        AssertXPath.assertXPath(this.desc, "/arquillian/container/protocol[2]/property/@name", PROPERTY_NAME_2);
        AssertXPath.assertXPath(this.desc, "/arquillian/container/protocol[2]/property/text()", PROPERTY_VALUE_2);
        ArquillianDescriptor descriptor = this.create(this.desc);
        Assert.assertEquals((long)1L, (long)descriptor.getContainers().size());
        Assert.assertEquals((Object)CONTAINER_NAME_1, (Object)((ContainerDef)descriptor.getContainers().get(0)).getContainerName());
        Assert.assertEquals((long)2L, (long)((ContainerDef)descriptor.getContainers().get(0)).getProtocols().size());
        Assert.assertEquals((Object)PROTOCOL_TYPE_1, (Object)((ProtocolDef)((ContainerDef)descriptor.getContainers().get(0)).getProtocols().get(0)).getType());
        Assert.assertEquals((Object)PROPERTY_VALUE_1, ((ProtocolDef)((ContainerDef)descriptor.getContainers().get(0)).getProtocols().get(0)).getProtocolProperties().get(PROPERTY_NAME_1));
        Assert.assertEquals((Object)PROTOCOL_TYPE_2, (Object)((ProtocolDef)((ContainerDef)descriptor.getContainers().get(0)).getProtocols().get(1)).getType());
        Assert.assertEquals((Object)PROPERTY_VALUE_2, ((ProtocolDef)((ContainerDef)descriptor.getContainers().get(0)).getProtocols().get(1)).getProtocolProperties().get(PROPERTY_NAME_2));
    }

    @Test
    public void shouldBeAbleToAddContainerAndOverwriteProtocol() throws Exception {
        this.desc = this.create().container(CONTAINER_NAME_1).protocol(PROTOCOL_TYPE_1).property(PROPERTY_NAME_1, PROPERTY_VALUE_1).protocol(PROTOCOL_TYPE_1).property(PROPERTY_NAME_1, PROPERTY_VALUE_2).exportAsString();
        AssertXPath.assertXPath(this.desc, "/arquillian/container/@qualifier", CONTAINER_NAME_1);
        AssertXPath.assertXPath(this.desc, "/arquillian/container/protocol/@type", PROTOCOL_TYPE_1);
        AssertXPath.assertXPath(this.desc, "/arquillian/container/protocol/property/@name", PROPERTY_NAME_1);
        AssertXPath.assertXPath(this.desc, "/arquillian/container/protocol/property/text()", PROPERTY_VALUE_2);
        ArquillianDescriptor descriptor = this.create(this.desc);
        Assert.assertEquals((long)1L, (long)descriptor.getContainers().size());
        Assert.assertEquals((long)1L, (long)((ContainerDef)descriptor.getContainers().get(0)).getProtocols().size());
        Assert.assertEquals((Object)PROTOCOL_TYPE_1, (Object)((ProtocolDef)((ContainerDef)descriptor.getContainers().get(0)).getProtocols().get(0)).getType());
        Assert.assertEquals((Object)PROPERTY_VALUE_2, ((ProtocolDef)((ContainerDef)descriptor.getContainers().get(0)).getProtocols().get(0)).getProtocolProperties().get(PROPERTY_NAME_1));
    }

    @Test
    public void shouldBeAbleToAddContainerWithConfiguration() throws Exception {
        this.desc = this.create().container(CONTAINER_NAME_1).property(PROPERTY_NAME_1, PROPERTY_VALUE_1).container(CONTAINER_NAME_2).property(PROPERTY_NAME_2, PROPERTY_VALUE_2).exportAsString();
        AssertXPath.assertXPath(this.desc, "/arquillian/container[1]/@qualifier", CONTAINER_NAME_1);
        AssertXPath.assertXPath(this.desc, "/arquillian/container[1]/configuration/property/@name", PROPERTY_NAME_1);
        AssertXPath.assertXPath(this.desc, "/arquillian/container[1]/configuration/property/text()", PROPERTY_VALUE_1);
        AssertXPath.assertXPath(this.desc, "/arquillian/container[2]/@qualifier", CONTAINER_NAME_2);
        AssertXPath.assertXPath(this.desc, "/arquillian/container[2]/configuration/property/@name", PROPERTY_NAME_2);
        AssertXPath.assertXPath(this.desc, "/arquillian/container[2]/configuration/property/text()", PROPERTY_VALUE_2);
        ArquillianDescriptor descriptor = this.create(this.desc);
        Assert.assertEquals((long)2L, (long)descriptor.getContainers().size());
        Assert.assertEquals((Object)CONTAINER_NAME_1, (Object)((ContainerDef)descriptor.getContainers().get(0)).getContainerName());
        Assert.assertEquals((Object)PROPERTY_VALUE_1, ((ContainerDef)descriptor.getContainers().get(0)).getContainerProperties().get(PROPERTY_NAME_1));
        Assert.assertEquals((Object)CONTAINER_NAME_2, (Object)((ContainerDef)descriptor.getContainers().get(1)).getContainerName());
        Assert.assertEquals((Object)PROPERTY_VALUE_2, ((ContainerDef)descriptor.getContainers().get(1)).getContainerProperties().get(PROPERTY_NAME_2));
    }

    @Test
    public void shouldBeAbleToAddContainerWithConfigurationAndOverwriteProperty() throws Exception {
        this.desc = this.create().container(CONTAINER_NAME_1).property(PROPERTY_NAME_1, PROPERTY_VALUE_1).property(PROPERTY_NAME_1, PROPERTY_VALUE_2).exportAsString();
        AssertXPath.assertXPath(this.desc, "/arquillian/container[1]/@qualifier", CONTAINER_NAME_1);
        AssertXPath.assertXPath(this.desc, "/arquillian/container[1]/configuration/property/@name", PROPERTY_NAME_1);
        AssertXPath.assertXPath(this.desc, "/arquillian/container[1]/configuration/property/text()", PROPERTY_VALUE_2);
        ArquillianDescriptor descriptor = this.create(this.desc);
        Assert.assertEquals((long)1L, (long)descriptor.getContainers().size());
        Assert.assertEquals((Object)CONTAINER_NAME_1, (Object)((ContainerDef)descriptor.getContainers().get(0)).getContainerName());
        Assert.assertEquals((long)1L, (long)((ContainerDef)descriptor.getContainers().get(0)).getContainerProperties().size());
        Assert.assertEquals((Object)PROPERTY_VALUE_2, ((ContainerDef)descriptor.getContainers().get(0)).getContainerProperties().get(PROPERTY_NAME_1));
    }

    @Test
    public void shouldBeAbleToAddGroupWithContainer() throws Exception {
        this.desc = this.create().group(GROUP_NAME_1).setGroupDefault().container(CONTAINER_NAME_1).container(CONTAINER_NAME_2).group(GROUP_NAME_2).container(CONTAINER_NAME_3).exportAsString();
        AssertXPath.assertXPath(this.desc, "/arquillian/group/@qualifier", GROUP_NAME_1, GROUP_NAME_2);
        AssertXPath.assertXPath(this.desc, "/arquillian/group[1]/@default", true);
        AssertXPath.assertXPath(this.desc, "/arquillian/group/container/@qualifier", CONTAINER_NAME_1, CONTAINER_NAME_2, CONTAINER_NAME_3);
        ArquillianDescriptor descriptor = this.create(this.desc);
        Assert.assertEquals((long)2L, (long)descriptor.getGroups().size());
        Assert.assertEquals((long)2L, (long)((GroupDef)descriptor.getGroups().get(0)).getGroupContainers().size());
        Assert.assertEquals((long)1L, (long)((GroupDef)descriptor.getGroups().get(1)).getGroupContainers().size());
        Assert.assertEquals((Object)GROUP_NAME_1, (Object)((GroupDef)descriptor.getGroups().get(0)).getGroupName());
        Assert.assertEquals((Object)CONTAINER_NAME_1, (Object)((ContainerDef)((GroupDef)descriptor.getGroups().get(0)).getGroupContainers().get(0)).getContainerName());
        Assert.assertEquals((Object)CONTAINER_NAME_2, (Object)((ContainerDef)((GroupDef)descriptor.getGroups().get(0)).getGroupContainers().get(1)).getContainerName());
        Assert.assertEquals((Object)GROUP_NAME_2, (Object)((GroupDef)descriptor.getGroups().get(1)).getGroupName());
        Assert.assertEquals((Object)CONTAINER_NAME_3, (Object)((ContainerDef)((GroupDef)descriptor.getGroups().get(1)).getGroupContainers().get(0)).getContainerName());
    }

    @Test
    public void shouldBeAbleToAddGroupWithContainerAndOverwriteContainer() throws Exception {
        this.desc = this.create().group(GROUP_NAME_1).container(CONTAINER_NAME_1).container(CONTAINER_NAME_1).exportAsString();
        AssertXPath.assertXPath(this.desc, "/arquillian/group/@qualifier", GROUP_NAME_1);
        AssertXPath.assertXPath(this.desc, "/arquillian/group/container/@qualifier", CONTAINER_NAME_1);
        ArquillianDescriptor descriptor = this.create(this.desc);
        Assert.assertEquals((long)1L, (long)descriptor.getGroups().size());
        Assert.assertEquals((long)1L, (long)((GroupDef)descriptor.getGroups().get(0)).getGroupContainers().size());
        Assert.assertEquals((Object)CONTAINER_NAME_1, (Object)((ContainerDef)((GroupDef)descriptor.getGroups().get(0)).getGroupContainers().get(0)).getContainerName());
    }

    @Test
    public void shouldBeAbleToAddExtension() throws Exception {
        this.desc = this.create().extension(EXTENSION_NAME_1).property(PROPERTY_NAME_1, PROPERTY_VALUE_1).property(PROPERTY_NAME_2, PROPERTY_VALUE_2).extension(EXTENSION_NAME_2).property(PROPERTY_NAME_3, PROPERTY_VALUE_3).exportAsString();
        AssertXPath.assertXPath(this.desc, "/arquillian/extension/@qualifier", EXTENSION_NAME_1, EXTENSION_NAME_2);
        AssertXPath.assertXPath(this.desc, "/arquillian/extension[1]/property[1]/@name", PROPERTY_NAME_1);
        AssertXPath.assertXPath(this.desc, "/arquillian/extension[1]/property[1]/text()", PROPERTY_VALUE_1);
        AssertXPath.assertXPath(this.desc, "/arquillian/extension[1]/property[2]/@name", PROPERTY_NAME_2);
        AssertXPath.assertXPath(this.desc, "/arquillian/extension[1]/property[2]/text()", PROPERTY_VALUE_2);
        AssertXPath.assertXPath(this.desc, "/arquillian/extension[2]/property/@name", PROPERTY_NAME_3);
        AssertXPath.assertXPath(this.desc, "/arquillian/extension[2]/property/text()", PROPERTY_VALUE_3);
        ArquillianDescriptor descriptor = this.create(this.desc);
        Assert.assertEquals((long)2L, (long)descriptor.getExtensions().size());
        Assert.assertEquals((Object)EXTENSION_NAME_1, (Object)((ExtensionDef)descriptor.getExtensions().get(0)).getExtensionName());
        Assert.assertEquals((long)2L, (long)((ExtensionDef)descriptor.getExtensions().get(0)).getExtensionProperties().size());
        Assert.assertEquals((Object)PROPERTY_VALUE_1, ((ExtensionDef)descriptor.getExtensions().get(0)).getExtensionProperties().get(PROPERTY_NAME_1));
        Assert.assertEquals((Object)PROPERTY_VALUE_2, ((ExtensionDef)descriptor.getExtensions().get(0)).getExtensionProperties().get(PROPERTY_NAME_2));
        Assert.assertEquals((Object)EXTENSION_NAME_2, (Object)((ExtensionDef)descriptor.getExtensions().get(1)).getExtensionName());
        Assert.assertEquals((long)1L, (long)((ExtensionDef)descriptor.getExtensions().get(1)).getExtensionProperties().size());
        Assert.assertEquals((Object)PROPERTY_VALUE_3, ((ExtensionDef)descriptor.getExtensions().get(1)).getExtensionProperties().get(PROPERTY_NAME_3));
    }

    @Test
    public void shouldBeAbleToRenameExtension() throws Exception {
        this.desc = this.create().extension(EXTENSION_NAME_1).property(PROPERTY_NAME_1, PROPERTY_VALUE_1).extension(EXTENSION_NAME_1).setExtensionName(EXTENSION_NAME_2).exportAsString();
        AssertXPath.assertXPath(this.desc, "/arquillian/extension/@qualifier", EXTENSION_NAME_2);
        ArquillianDescriptor descriptor = this.create(this.desc);
        Assert.assertEquals((long)1L, (long)descriptor.getExtensions().size());
        Assert.assertEquals((Object)EXTENSION_NAME_2, (Object)((ExtensionDef)descriptor.getExtensions().get(0)).getExtensionName());
        Assert.assertEquals((long)1L, (long)((ExtensionDef)descriptor.getExtensions().get(0)).getExtensionProperties().size());
        Assert.assertEquals((Object)PROPERTY_VALUE_1, ((ExtensionDef)descriptor.getExtensions().get(0)).getExtensionProperties().get(PROPERTY_NAME_1));
    }

    @Test
    public void shouldBeAbleToAddExtensionAndOverwriteProperty() throws Exception {
        this.desc = this.create().extension(EXTENSION_NAME_1).property(PROPERTY_NAME_1, PROPERTY_VALUE_1).property(PROPERTY_NAME_1, PROPERTY_VALUE_2).exportAsString();
        AssertXPath.assertXPath(this.desc, "/arquillian/extension/@qualifier", EXTENSION_NAME_1);
        AssertXPath.assertXPath(this.desc, "/arquillian/extension/property/@name", PROPERTY_NAME_1);
        AssertXPath.assertXPath(this.desc, "/arquillian/extension/property/text()", PROPERTY_VALUE_2);
        ArquillianDescriptor descriptor = this.create(this.desc);
        Assert.assertEquals((long)1L, (long)descriptor.getExtensions().size());
        Assert.assertEquals((Object)EXTENSION_NAME_1, (Object)((ExtensionDef)descriptor.getExtensions().get(0)).getExtensionName());
        Assert.assertEquals((long)1L, (long)((ExtensionDef)descriptor.getExtensions().get(0)).getExtensionProperties().size());
        Assert.assertEquals((Object)PROPERTY_VALUE_2, ((ExtensionDef)descriptor.getExtensions().get(0)).getExtensionProperties().get(PROPERTY_NAME_1));
    }

    @Test
    public void shouldBeAbleToAddEverything() throws Exception {
        this.desc = this.create().defaultProtocol(PROTOCOL_TYPE_1).property(PROPERTY_VALUE_3, PROPERTY_VALUE_3).container(CONTAINER_NAME_1).property(PROPERTY_NAME_1, PROPERTY_VALUE_1).dependency(DEPENDENCY_1).protocol(PROTOCOL_TYPE_1).property(PROPERTY_NAME_2, PROPERTY_VALUE_2).group(GROUP_NAME_1).container(CONTAINER_NAME_2).property(PROPERTY_NAME_1, PROPERTY_VALUE_1).dependency(DEPENDENCY_2).protocol(PROTOCOL_TYPE_2).property(PROPERTY_NAME_3, PROPERTY_VALUE_3).group(GROUP_NAME_2).container(CONTAINER_NAME_3).protocol(PROTOCOL_TYPE_3).property(PROPERTY_NAME_1, PROPERTY_VALUE_1).container(CONTAINER_NAME_4).extension(EXTENSION_NAME_1).property(PROPERTY_NAME_1, PROPERTY_VALUE_2).exportAsString();
    }

    private ArquillianDescriptor create() {
        return (ArquillianDescriptor)Descriptors.create(ArquillianDescriptor.class);
    }

    private ArquillianDescriptor create(String xml) throws Exception {
        this.validateXML(this.desc);
        return (ArquillianDescriptor)Descriptors.importAs(ArquillianDescriptor.class).from(xml);
    }

    private void validateXML(String xml) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(true);
        dbf.setNamespaceAware(true);
        dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        DocumentBuilder db = dbf.newDocumentBuilder();
        db.setErrorHandler(new ErrorHandler(){

            public void warning(SAXParseException exception) throws SAXException {
                throw exception;
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                throw exception;
            }

            public void error(SAXParseException exception) throws SAXException {
                throw exception;
            }
        });
        db.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if ("http://jboss.org/schema/arquillian/arquillian_1_0.xsd".equals(systemId)) {
                    return new InputSource(this.getClass().getClassLoader().getResourceAsStream("arquillian_1_0.xsd"));
                }
                return null;
            }
        });
        db.parse(new ByteArrayInputStream(xml.getBytes()));
    }
}

