/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.config.impl.extension;

import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ContainerDef;
import org.jboss.arquillian.config.descriptor.api.DefaultProtocolDef;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.jboss.arquillian.config.descriptor.api.ProtocolDef;

class PropertiesParser {
    private static String ARQ_PROPERTY = "arq\\..*";
    private static String ARQ_ENGINE_PROPERTY = "arq\\.engine\\.(.*)";
    private static String ARQ_CONTAINER = "arq\\.container\\.(.*)\\.(.*)";
    private static String ARQ_CONTAINER_CONFIGURATION = "arq\\.container\\.(.*)\\.configuration\\.(.*)";
    private static String ARQ_CONTAINER_PROTOCOL = "arq\\.container\\.(.*)\\.protocol\\.(.*)\\.(.*)";
    private static String ARQ_GROUP = "arq\\.group\\.(.*)\\.(.*)";
    private static String ARQ_GROUP_CONTAINER = "arq\\.group\\.(.*)\\.container\\.(.*)\\.(.*)";
    private static String ARQ_GROUP_CONTAINER_CONFIGURATION = "arq\\.group\\.(.*)\\.container\\.(.*)\\.configuration\\.(.*)";
    private static String ARQ_GROUP_CONTAINER_PROTOCOL = "arq\\.group\\.(.*)\\.container\\.(.*)\\.protocol\\.(.*)\\.(.*)";
    private static String ARQ_DEFAULT_PROTOCOL = "arq\\.defaultprotocol\\.(.*)\\.(.*)";
    private static String ARQ_EXTENSION = "arq\\.extension\\.(.*)\\.(.*)";
    private static String ORIGINAL_VALUE = "[ORIGINAL]";
    private Handler[] handlers = new Handler[]{new EngineProperty(ARQ_ENGINE_PROPERTY), new ContainerConfiguration(ARQ_CONTAINER_CONFIGURATION), new ContainerProtocol(ARQ_CONTAINER_PROTOCOL), new Container(ARQ_CONTAINER), new Extension(ARQ_EXTENSION), new GroupContainerConfiguration(ARQ_GROUP_CONTAINER_CONFIGURATION), new GroupContainerProtocol(ARQ_GROUP_CONTAINER_PROTOCOL), new GroupContainer(ARQ_GROUP_CONTAINER), new Group(ARQ_GROUP), new DefaultProtocol(ARQ_DEFAULT_PROTOCOL)};

    PropertiesParser() {
    }

    void addProperties(ArquillianDescriptor descriptor, Properties properties) {
        if (descriptor == null) {
            throw new IllegalArgumentException("Descriptor must be specified");
        }
        if (properties == null) {
            throw new IllegalArgumentException("Properties must be specified");
        }
        Set<Map.Entry<Object, Object>> filteredProps = this.filterProperties(properties);
        for (Map.Entry<Object, Object> entry : filteredProps) {
            for (Handler handler : this.handlers) {
                if (handler.handle(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()), descriptor)) break;
            }
        }
    }

    private Set<Map.Entry<Object, Object>> filterProperties(Properties properties) {
        HashSet<Map.Entry<Object, Object>> filtered = new HashSet<Map.Entry<Object, Object>>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (!String.valueOf(entry.getKey()).matches(ARQ_PROPERTY)) continue;
            filtered.add(entry);
        }
        return filtered;
    }

    private abstract class Handler {
        private Pattern expression;

        Handler(String expression) {
            this.expression = Pattern.compile(expression);
        }

        boolean handle(String propertyName, String value, ArquillianDescriptor descriptor) {
            Matcher matcher = this.expression.matcher(propertyName);
            if (matcher.matches()) {
                this.handle(matcher, value, descriptor);
                return true;
            }
            return false;
        }

        protected abstract void handle(Matcher var1, String var2, ArquillianDescriptor var3);
    }

    private class EngineProperty
    extends Handler {
        EngineProperty(String expression) {
            super(expression);
        }

        @Override
        protected void handle(Matcher matcher, String value, ArquillianDescriptor descriptor) {
            String propertyName = matcher.group(1);
            if ("deploymentExportPath".equals(propertyName)) {
                descriptor.engine().deploymentExportPath(value);
            } else if ("maxTestClassesBeforeRestart".equals(propertyName)) {
                descriptor.engine().maxTestClassesBeforeRestart(Integer.valueOf(Integer.parseInt(value)));
            } else {
                throw new RuntimeException("Unknown arquillian engine property[" + propertyName + "] with value[" + value + "]");
            }
        }
    }

    private class ContainerConfiguration
    extends Handler {
        ContainerConfiguration(String expression) {
            super(expression);
        }

        @Override
        protected void handle(Matcher matcher, String value, ArquillianDescriptor descriptor) {
            String containerName = matcher.group(1);
            String propertyName = matcher.group(2);
            ContainerDef containerDef = descriptor.container(containerName);
            String originalValue = containerDef.getContainerProperty(propertyName);
            if (value.contains(ORIGINAL_VALUE)) {
                containerDef.property(propertyName, value.replace(ORIGINAL_VALUE, originalValue != null ? originalValue : ""));
            } else {
                containerDef.property(propertyName, value);
            }
        }
    }

    private class ContainerProtocol
    extends Handler {
        ContainerProtocol(String expression) {
            super(expression);
        }

        @Override
        protected void handle(Matcher matcher, String value, ArquillianDescriptor descriptor) {
            String containerName = matcher.group(1);
            String protocolName = matcher.group(2);
            String propertyName = matcher.group(3);
            ProtocolDef protocolDef = descriptor.container(containerName).protocol(protocolName);
            String originalValue = protocolDef.getProtocolProperty(propertyName);
            if (value.contains(ORIGINAL_VALUE)) {
                protocolDef.property(propertyName, value.replace(ORIGINAL_VALUE, originalValue != null ? originalValue : ""));
            } else {
                protocolDef.property(propertyName, value);
            }
        }
    }

    private class Container
    extends Handler {
        public Container(String expression) {
            super(expression);
        }

        @Override
        protected void handle(Matcher matcher, String value, ArquillianDescriptor descriptor) {
            String containerName = matcher.group(1);
            String attributeName = matcher.group(2);
            if ("mode".equals(attributeName)) {
                descriptor.container(containerName).setMode(value);
            } else if ("default".equals(attributeName)) {
                descriptor.container(containerName).setDefault();
            } else {
                throw new RuntimeException("Unknown arquillian container attribute[" + attributeName + "] with value[" + value + "]");
            }
        }
    }

    private class Extension
    extends Handler {
        public Extension(String expression) {
            super(expression);
        }

        @Override
        protected void handle(Matcher matcher, String value, ArquillianDescriptor descriptor) {
            String extensionName = matcher.group(1);
            String propertyName = matcher.group(2);
            ExtensionDef extensionDef = descriptor.extension(extensionName);
            String originalValue = extensionDef.getExtensionProperty(propertyName);
            if (value.contains(ORIGINAL_VALUE)) {
                extensionDef.property(propertyName, value.replace(ORIGINAL_VALUE, originalValue != null ? originalValue : ""));
            } else {
                extensionDef.property(propertyName, value);
            }
        }
    }

    private class GroupContainerConfiguration
    extends Handler {
        GroupContainerConfiguration(String expression) {
            super(expression);
        }

        @Override
        protected void handle(Matcher matcher, String value, ArquillianDescriptor descriptor) {
            String groupName = matcher.group(1);
            String containerName = matcher.group(2);
            String propertyName = matcher.group(3);
            ContainerDef containerDef = descriptor.group(groupName).container(containerName);
            String originalValue = containerDef.getContainerProperty(propertyName);
            if (value.contains(ORIGINAL_VALUE)) {
                containerDef.property(propertyName, value.replace(ORIGINAL_VALUE, originalValue != null ? originalValue : ""));
            } else {
                containerDef.property(propertyName, value);
            }
        }
    }

    private class GroupContainerProtocol
    extends Handler {
        GroupContainerProtocol(String expression) {
            super(expression);
        }

        @Override
        protected void handle(Matcher matcher, String value, ArquillianDescriptor descriptor) {
            String groupName = matcher.group(1);
            String containerName = matcher.group(2);
            String protocolName = matcher.group(3);
            String propertyName = matcher.group(4);
            ProtocolDef protocolDef = descriptor.group(groupName).container(containerName).protocol(protocolName);
            String originalValue = protocolDef.getProtocolProperty(propertyName);
            if (value.contains(ORIGINAL_VALUE)) {
                protocolDef.property(propertyName, value.replace(ORIGINAL_VALUE, originalValue != null ? originalValue : ""));
            } else {
                protocolDef.property(propertyName, value);
            }
        }
    }

    private class GroupContainer
    extends Handler {
        GroupContainer(String expression) {
            super(expression);
        }

        @Override
        protected void handle(Matcher matcher, String value, ArquillianDescriptor descriptor) {
            String groupName = matcher.group(1);
            String containerName = matcher.group(2);
            String attributeName = matcher.group(3);
            if ("mode".equals(attributeName)) {
                descriptor.group(groupName).container(containerName).setMode(value);
            } else if ("default".equals(attributeName)) {
                descriptor.group(groupName).container(containerName).setDefault();
            } else {
                throw new RuntimeException("Unknown arquillian container attribute[" + attributeName + "] with value[" + value + "]");
            }
        }
    }

    private class Group
    extends Handler {
        Group(String expression) {
            super(expression);
        }

        @Override
        protected void handle(Matcher matcher, String value, ArquillianDescriptor descriptor) {
            String groupName = matcher.group(1);
            String attributeName = matcher.group(2);
            if (!"default".equals(attributeName)) {
                throw new RuntimeException("Unknown arquillian container attribute[" + attributeName + "] with value[" + value + "]");
            }
            descriptor.group(groupName).setGroupDefault();
        }
    }

    private class DefaultProtocol
    extends Handler {
        DefaultProtocol(String expression) {
            super(expression);
        }

        @Override
        protected void handle(Matcher matcher, String value, ArquillianDescriptor descriptor) {
            String typeName = matcher.group(1);
            String propertyName = matcher.group(2);
            DefaultProtocolDef defaultProtocolDef = descriptor.defaultProtocol(typeName);
            String originalValue = defaultProtocolDef.getProperty(propertyName);
            if (value.contains(ORIGINAL_VALUE)) {
                defaultProtocolDef.property(propertyName, value.replace(ORIGINAL_VALUE, originalValue != null ? originalValue : ""));
            } else {
                defaultProtocolDef.property(propertyName, value);
            }
        }
    }
}

