/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.config.impl.extension;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ContainerDef;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.jboss.arquillian.config.descriptor.api.GroupDef;
import org.jboss.arquillian.config.descriptor.api.ProtocolDef;
import org.jboss.arquillian.config.impl.extension.ConfigurationRegistrar;
import org.jboss.arquillian.config.impl.extension.SystemPropertiesConfigurationPlaceholderResolver;
import org.jboss.arquillian.config.spi.ConfigurationPlaceholderResolver;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.event.ManagerStarted;
import org.jboss.arquillian.core.spi.Manager;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.core.spi.context.Context;
import org.jboss.arquillian.core.test.AbstractManagerTestBase;
import org.jboss.arquillian.test.impl.context.SuiteContextImpl;
import org.jboss.arquillian.test.spi.annotation.SuiteScoped;
import org.jboss.arquillian.test.spi.context.SuiteContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ConfigurationRegistrarTestCase
extends AbstractManagerTestBase {
    @Mock
    private ServiceLoader serviceLoader;
    @Inject
    private Instance<Injector> injectorInst;
    @Inject
    private Instance<ArquillianDescriptor> descInst;
    private ConfigurationRegistrar registrar;

    static void validate(String property, String value, AssertCallback callback) {
        try {
            System.setProperty(property, value);
            callback.validate();
        }
        finally {
            System.clearProperty(property);
        }
    }

    @Before
    public void injectConfigurationRegistrar() {
        SystemPropertiesConfigurationPlaceholderResolver configurationSysPropResolver = new SystemPropertiesConfigurationPlaceholderResolver();
        Mockito.when((Object)this.serviceLoader.all(ConfigurationPlaceholderResolver.class)).thenReturn(Arrays.asList(configurationSysPropResolver));
        this.bind(SuiteScoped.class, ServiceLoader.class, this.serviceLoader);
        this.registrar = (ConfigurationRegistrar)((Injector)this.injectorInst.get()).inject((Object)new ConfigurationRegistrar());
    }

    @Test
    public void shouldBeAbleToLoadEmptyDefaultConfiguration() throws Exception {
        this.registrar.loadConfiguration(new ManagerStarted());
        ArquillianDescriptor desc = (ArquillianDescriptor)this.descInst.get();
        Assert.assertEquals((long)0L, (long)desc.getContainers().size());
        Assert.assertEquals((long)0L, (long)desc.getGroups().size());
        Assert.assertEquals((long)0L, (long)desc.getExtensions().size());
    }

    @Test
    public void shouldBeAbleToLoadConfiguredXMLFileResource() throws Exception {
        ConfigurationRegistrarTestCase.validate("arquillian.xml", "registrar_tests/named_arquillian.xml", new AssertCallback(){

            @Override
            public void validate() {
                ConfigurationRegistrarTestCase.this.registrar.loadConfiguration(new ManagerStarted());
                ArquillianDescriptor desc = (ArquillianDescriptor)ConfigurationRegistrarTestCase.this.descInst.get();
                Assert.assertEquals((long)1L, (long)desc.getContainers().size());
                Assert.assertEquals((Object)"A", (Object)((ContainerDef)desc.getContainers().get(0)).getContainerName());
                Assert.assertEquals((Object)"class", (Object)((ContainerDef)desc.getContainers().get(0)).getMode());
            }
        });
    }

    @Test
    public void shouldBeAbleToLoadConfiguredXMLClasspathResource() throws Exception {
        ConfigurationRegistrarTestCase.validate("arquillian.xml", "registrar_tests/named_arquillian.xml", new AssertCallback(){

            @Override
            public void validate() {
                ConfigurationRegistrarTestCase.this.registrar.loadConfiguration(new ManagerStarted());
                ArquillianDescriptor desc = (ArquillianDescriptor)ConfigurationRegistrarTestCase.this.descInst.get();
                Assert.assertEquals((long)1L, (long)desc.getContainers().size());
                Assert.assertEquals((Object)"A", (Object)((ContainerDef)desc.getContainers().get(0)).getContainerName());
                Assert.assertEquals((Object)"class", (Object)((ContainerDef)desc.getContainers().get(0)).getMode());
            }
        });
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionOnMissingConfiguredXMLResource() throws Exception {
        ConfigurationRegistrarTestCase.validate("arquillian.xml", "registrar_tests/named_arquillian_SHOULD_NOT_BE_FOUND_.xml", new AssertCallback(){

            @Override
            public void validate() {
                ConfigurationRegistrarTestCase.this.registrar.loadConfiguration(new ManagerStarted());
            }
        });
    }

    @Test
    public void shouldBeAbleToLoadConfiguredPropertiesFileResource() throws Exception {
        ConfigurationRegistrarTestCase.validate("arquillian.properties", "registrar_tests/named_arquillian.properties", new AssertCallback(){

            @Override
            public void validate() {
                ConfigurationRegistrarTestCase.this.registrar.loadConfiguration(new ManagerStarted());
                ArquillianDescriptor desc = (ArquillianDescriptor)ConfigurationRegistrarTestCase.this.descInst.get();
                Assert.assertEquals((long)1L, (long)desc.getContainers().size());
                Assert.assertEquals((Object)"B", (Object)((ContainerDef)desc.getContainers().get(0)).getContainerName());
            }
        });
    }

    @Test
    public void shouldBeAbleToLoadConfiguredPropertiesClasspathResource() throws Exception {
        ConfigurationRegistrarTestCase.validate("arquillian.properties", "registrar_tests/named_arquillian.properties", new AssertCallback(){

            @Override
            public void validate() {
                ConfigurationRegistrarTestCase.this.registrar.loadConfiguration(new ManagerStarted());
                ArquillianDescriptor desc = (ArquillianDescriptor)ConfigurationRegistrarTestCase.this.descInst.get();
                Assert.assertEquals((long)1L, (long)desc.getContainers().size());
                Assert.assertEquals((Object)"B", (Object)((ContainerDef)desc.getContainers().get(0)).getContainerName());
                Assert.assertEquals((Object)"manual", (Object)((ContainerDef)desc.getContainers().get(0)).getMode());
            }
        });
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionOnMissingConfiguredPropertiesResource() throws Exception {
        ConfigurationRegistrarTestCase.validate("arquillian.properties", "registrar_tests/named_arquillian_SHOULD_NOT_BE_FOUND_.properties", new AssertCallback(){

            @Override
            public void validate() {
                ConfigurationRegistrarTestCase.this.registrar.loadConfiguration(new ManagerStarted());
            }
        });
    }

    @Test
    public void shouldBeAbleToAddSystemProperties() throws Exception {
        ConfigurationRegistrarTestCase.validate("arq.container.C.mode", "manual", new AssertCallback(){

            @Override
            public void validate() {
                ConfigurationRegistrarTestCase.this.registrar.loadConfiguration(new ManagerStarted());
                ArquillianDescriptor desc = (ArquillianDescriptor)ConfigurationRegistrarTestCase.this.descInst.get();
                Assert.assertEquals((long)1L, (long)desc.getContainers().size());
                Assert.assertEquals((Object)"C", (Object)((ContainerDef)desc.getContainers().get(0)).getContainerName());
                Assert.assertEquals((Object)"manual", (Object)((ContainerDef)desc.getContainers().get(0)).getMode());
            }
        });
    }

    @Test
    public void shouldBeAbleToOverrideWithSystemProperties() throws Exception {
        ConfigurationRegistrarTestCase.validate("arquillian.xml", "registrar_tests/named_arquillian.xml", new AssertCallback(){

            @Override
            public void validate() {
                ConfigurationRegistrarTestCase.validate("arq.container.A.mode", "suite", new AssertCallback(){

                    @Override
                    public void validate() {
                        ConfigurationRegistrarTestCase.this.registrar.loadConfiguration(new ManagerStarted());
                        ArquillianDescriptor desc = (ArquillianDescriptor)ConfigurationRegistrarTestCase.this.descInst.get();
                        Assert.assertEquals((long)1L, (long)desc.getContainers().size());
                        Assert.assertEquals((Object)"A", (Object)((ContainerDef)desc.getContainers().get(0)).getContainerName());
                        Assert.assertEquals((Object)"suite", (Object)((ContainerDef)desc.getContainers().get(0)).getMode());
                    }
                });
            }
        });
    }

    @Test
    public void shouldBeAbleToAddToXMLWithProperties() throws Exception {
        ConfigurationRegistrarTestCase.validate("arquillian.xml", "registrar_tests/named_arquillian.xml", new AssertCallback(){

            @Override
            public void validate() {
                ConfigurationRegistrarTestCase.validate("arquillian.properties", "registrar_tests/named_arquillian.properties", new AssertCallback(){

                    @Override
                    public void validate() {
                        ConfigurationRegistrarTestCase.this.registrar.loadConfiguration(new ManagerStarted());
                        ArquillianDescriptor desc = (ArquillianDescriptor)ConfigurationRegistrarTestCase.this.descInst.get();
                        Assert.assertEquals((long)2L, (long)desc.getContainers().size());
                        Assert.assertEquals((Object)"A", (Object)((ContainerDef)desc.getContainers().get(0)).getContainerName());
                        Assert.assertEquals((Object)"B", (Object)((ContainerDef)desc.getContainers().get(1)).getContainerName());
                    }
                });
            }
        });
    }

    @Test
    public void shouldBeAbleToOverrideToXMLWithProperties() throws Exception {
        ConfigurationRegistrarTestCase.validate("arquillian.xml", "registrar_tests/named_arquillian.xml", new AssertCallback(){

            @Override
            public void validate() {
                ConfigurationRegistrarTestCase.validate("arquillian.properties", "registrar_tests/override_named_arquillian.properties", new AssertCallback(){

                    @Override
                    public void validate() {
                        ConfigurationRegistrarTestCase.this.registrar.loadConfiguration(new ManagerStarted());
                        ArquillianDescriptor desc = (ArquillianDescriptor)ConfigurationRegistrarTestCase.this.descInst.get();
                        Assert.assertEquals((long)1L, (long)desc.getContainers().size());
                        Assert.assertEquals((Object)"A", (Object)((ContainerDef)desc.getContainers().get(0)).getContainerName());
                        Assert.assertEquals((Object)"suite", (Object)((ContainerDef)desc.getContainers().get(0)).getMode());
                    }
                });
            }
        });
    }

    @Test
    public void shouldToOverrideToPropertiesWithSystemEnvironment() throws Exception {
        ConfigurationRegistrarTestCase.validate("arquillian.xml", "registrar_tests/named_arquillian.xml", new AssertCallback(){

            @Override
            public void validate() {
                ConfigurationRegistrarTestCase.validate("arquillian.properties", "registrar_tests/override_named_arquillian.properties", new AssertCallback(){

                    @Override
                    public void validate() {
                        HashMap<String, String> envVars = new HashMap<String, String>();
                        envVars.put("arq.container.A.mode", "none");
                        ConfigurationRegistrarTestCase.this.registrar.setEnvironmentVariables(envVars);
                        ConfigurationRegistrarTestCase.this.registrar.loadConfiguration(new ManagerStarted());
                        ArquillianDescriptor desc = (ArquillianDescriptor)ConfigurationRegistrarTestCase.this.descInst.get();
                        Assert.assertEquals((long)1L, (long)desc.getContainers().size());
                        Assert.assertEquals((Object)"A", (Object)((ContainerDef)desc.getContainers().get(0)).getContainerName());
                        Assert.assertEquals((Object)"none", (Object)((ContainerDef)desc.getContainers().get(0)).getMode());
                    }
                });
            }
        });
    }

    @Test
    public void shouldBeAbleToOverrideDefaultProtocolTXMLWithPlaceholderReplace() throws Exception {
        ConfigurationRegistrarTestCase.validate("env.ENV1", "env1", new AssertCallback(){

            @Override
            public void validate() {
                ConfigurationRegistrarTestCase.validate("env.ENV3", "env3", new AssertCallback(){

                    @Override
                    public void validate() {
                        ConfigurationRegistrarTestCase.validate("arquillian.xml", "registrar_tests/property_arquillian.xml", new AssertCallback(){

                            @Override
                            public void validate() {
                                ConfigurationRegistrarTestCase.validate("arquillian.properties", "registrar_tests/property_arquillian.properties", new AssertCallback(){

                                    @Override
                                    public void validate() {
                                        ConfigurationRegistrarTestCase.this.registrar.loadConfiguration(new ManagerStarted());
                                        ArquillianDescriptor desc = (ArquillianDescriptor)ConfigurationRegistrarTestCase.this.descInst.get();
                                        Assert.assertNotNull((Object)desc.getDefaultProtocol());
                                        Assert.assertEquals((Object)"X BBB X", (Object)desc.getDefaultProtocol().getProperty("bbb"));
                                        Assert.assertEquals((Object)"X  X", (Object)desc.getDefaultProtocol().getProperty("bbb2"));
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    @Test
    public void shouldBeAbleToOverrideContainersToXMLWithPlaceholderReplace() throws Exception {
        ConfigurationRegistrarTestCase.validate("env.ENV1", "env1", new AssertCallback(){

            @Override
            public void validate() {
                ConfigurationRegistrarTestCase.validate("env.ENV3", "env3", new AssertCallback(){

                    @Override
                    public void validate() {
                        ConfigurationRegistrarTestCase.validate("arquillian.xml", "registrar_tests/property_arquillian.xml", new AssertCallback(){

                            @Override
                            public void validate() {
                                ConfigurationRegistrarTestCase.validate("arquillian.properties", "registrar_tests/property_arquillian.properties", new AssertCallback(){

                                    @Override
                                    public void validate() {
                                        ConfigurationRegistrarTestCase.this.registrar.loadConfiguration(new ManagerStarted());
                                        ArquillianDescriptor desc = (ArquillianDescriptor)ConfigurationRegistrarTestCase.this.descInst.get();
                                        Assert.assertEquals((long)1L, (long)desc.getContainers().size());
                                        Assert.assertNotNull(desc.getContainers().get(0));
                                        Assert.assertNotNull((String)"Y AAA Y", (Object)((ContainerDef)desc.getContainers().get(0)).getContainerProperty("aaa"));
                                        Assert.assertNotNull((String)"Y  Y", (Object)((ContainerDef)desc.getContainers().get(0)).getContainerProperty("aaa2"));
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    @Test
    public void shouldBeAbleToOverrideExtensionsToXMLWithPlaceholderReplace() throws Exception {
        ConfigurationRegistrarTestCase.validate("env.ENV1", "env1", new AssertCallback(){

            @Override
            public void validate() {
                ConfigurationRegistrarTestCase.validate("env.ENV3", "env3", new AssertCallback(){

                    @Override
                    public void validate() {
                        ConfigurationRegistrarTestCase.validate("arquillian.xml", "registrar_tests/property_arquillian.xml", new AssertCallback(){

                            @Override
                            public void validate() {
                                ConfigurationRegistrarTestCase.validate("arquillian.properties", "registrar_tests/property_arquillian.properties", new AssertCallback(){

                                    @Override
                                    public void validate() {
                                        ConfigurationRegistrarTestCase.this.registrar.loadConfiguration(new ManagerStarted());
                                        ArquillianDescriptor desc = (ArquillianDescriptor)ConfigurationRegistrarTestCase.this.descInst.get();
                                        Assert.assertEquals((long)1L, (long)desc.getExtensions().size());
                                        Assert.assertNotNull(desc.getExtensions().get(0));
                                        Assert.assertNotNull((String)"Z DDD Z", (Object)((ExtensionDef)desc.getExtensions().get(0)).getExtensionProperty("ddd"));
                                        Assert.assertNotNull((String)"Z  Z", (Object)((ExtensionDef)desc.getExtensions().get(0)).getExtensionProperty("ddd2"));
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    @Test
    public void shouldBeAbleToOverrideGroupsToXMLWithPlaceholderReplace() throws Exception {
        ConfigurationRegistrarTestCase.validate("env.ENV1", "env1", new AssertCallback(){

            @Override
            public void validate() {
                ConfigurationRegistrarTestCase.validate("env.ENV3", "env3", new AssertCallback(){

                    @Override
                    public void validate() {
                        ConfigurationRegistrarTestCase.validate("arquillian.xml", "registrar_tests/property_arquillian.xml", new AssertCallback(){

                            @Override
                            public void validate() {
                                ConfigurationRegistrarTestCase.validate("arquillian.properties", "registrar_tests/property_arquillian.properties", new AssertCallback(){

                                    @Override
                                    public void validate() {
                                        ConfigurationRegistrarTestCase.this.registrar.loadConfiguration(new ManagerStarted());
                                        ArquillianDescriptor desc = (ArquillianDescriptor)ConfigurationRegistrarTestCase.this.descInst.get();
                                        Assert.assertEquals((long)2L, (long)desc.getGroups().size());
                                        Assert.assertNotNull(desc.getGroups().get(0));
                                        Assert.assertEquals((long)1L, (long)((GroupDef)desc.getGroups().get(0)).getGroupContainers().size());
                                        Assert.assertEquals((Object)"T EEE T", (Object)((ContainerDef)((GroupDef)desc.getGroups().get(0)).getGroupContainers().get(0)).getContainerProperty("eee"));
                                        Assert.assertEquals((Object)"T  T", (Object)((ContainerDef)((GroupDef)desc.getGroups().get(0)).getGroupContainers().get(0)).getContainerProperty("eee2"));
                                        Assert.assertEquals((long)1L, (long)((ContainerDef)((GroupDef)desc.getGroups().get(0)).getGroupContainers().get(0)).getProtocols().size());
                                        Assert.assertEquals((Object)"R FFF R", (Object)((ProtocolDef)((ContainerDef)((GroupDef)desc.getGroups().get(0)).getGroupContainers().get(0)).getProtocols().get(0)).getProtocolProperty("fff"));
                                        Assert.assertEquals((Object)"R  R", (Object)((ProtocolDef)((ContainerDef)((GroupDef)desc.getGroups().get(0)).getGroupContainers().get(0)).getProtocols().get(0)).getProtocolProperty("fff2"));
                                        Assert.assertEquals((Object)"env1", (Object)((ProtocolDef)((ContainerDef)((GroupDef)desc.getGroups().get(0)).getGroupContainers().get(0)).getProtocols().get(0)).getProtocolProperty("ggg1"));
                                        Assert.assertEquals((Object)"${env.ENV2}", (Object)((ProtocolDef)((ContainerDef)((GroupDef)desc.getGroups().get(0)).getGroupContainers().get(0)).getProtocols().get(0)).getProtocolProperty("ggg2"));
                                        Assert.assertEquals((Object)"G env1 G", (Object)((ProtocolDef)((ContainerDef)((GroupDef)desc.getGroups().get(0)).getGroupContainers().get(0)).getProtocols().get(0)).getProtocolProperty("ggg3"));
                                        Assert.assertEquals((Object)"env3 HHH", (Object)((ProtocolDef)((ContainerDef)((GroupDef)desc.getGroups().get(0)).getGroupContainers().get(0)).getProtocols().get(0)).getProtocolProperty("hhh1"));
                                        Assert.assertEquals((Object)"${env.ENV4} HHH", (Object)((ProtocolDef)((ContainerDef)((GroupDef)desc.getGroups().get(0)).getGroupContainers().get(0)).getProtocols().get(0)).getProtocolProperty("hhh2"));
                                        Assert.assertEquals((Object)"H env1 HHH H", (Object)((ProtocolDef)((ContainerDef)((GroupDef)desc.getGroups().get(0)).getGroupContainers().get(0)).getProtocols().get(0)).getProtocolProperty("hhh3"));
                                        Assert.assertEquals((Object)"env1  ${env.ENV2}", (Object)((ProtocolDef)((ContainerDef)((GroupDef)desc.getGroups().get(0)).getGroupContainers().get(0)).getProtocols().get(0)).getProtocolProperty("hhh4"));
                                        Assert.assertNotNull(desc.getGroups().get(1));
                                        Assert.assertEquals((long)1L, (long)((GroupDef)desc.getGroups().get(1)).getGroupContainers().size());
                                        Assert.assertEquals((Object)"WITHOUT ", (Object)((ProtocolDef)((ContainerDef)((GroupDef)desc.getGroups().get(1)).getGroupContainers().get(0)).getProtocols().get(0)).getProtocolProperty("foo"));
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    protected void addContexts(List<Class<? extends Context>> contexts) {
        super.addContexts(contexts);
        contexts.add(SuiteContextImpl.class);
    }

    protected void startContexts(Manager manager) {
        super.startContexts(manager);
        ((SuiteContext)manager.getContext(SuiteContext.class)).activate();
    }

    public static interface AssertCallback {
        public void validate();
    }
}

