/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.config.impl.extension;

import java.net.URL;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ContainerDef;
import org.jboss.arquillian.config.descriptor.impl.AssertXPath;
import org.jboss.arquillian.config.impl.extension.ClasspathConfigurationPlaceholderResolver;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.junit.Test;

public class ArquillianDescriptorClasspathPropertiesTestCase {
    @Test
    public void should_replace_properties_with_classpath_location() throws Exception {
        String element = "arquillian_sysprop.xml";
        ContainerDef desc = this.create().container("daemon").property("javaVmArguments", "-Djavax.net.ssl.trustStore=${classpath(" + element + ")}");
        ClasspathConfigurationPlaceholderResolver classpathConfigurationPlaceholderResolver = new ClasspathConfigurationPlaceholderResolver();
        desc = classpathConfigurationPlaceholderResolver.resolve((ArquillianDescriptor)desc);
        String descString = desc.exportAsString();
        URL resource = Thread.currentThread().getContextClassLoader().getResource(element);
        AssertXPath.assertXPath(descString, "/arquillian/container/configuration/property", String.format("-Djavax.net.ssl.trustStore=%s", resource.toString()));
    }

    @Test
    public void should_not_replace_placeholder_if_classpath_resource_not_found() throws Exception {
        String element = "notfound.txt";
        ContainerDef desc = this.create().container("daemon").property("javaVmArguments", "-Djavax.net.ssl.trustStore=${classpath(" + element + ")}");
        ClasspathConfigurationPlaceholderResolver classpathConfigurationPlaceholderResolver = new ClasspathConfigurationPlaceholderResolver();
        desc = classpathConfigurationPlaceholderResolver.resolve((ArquillianDescriptor)desc);
        String descString = desc.exportAsString();
        AssertXPath.assertXPath(descString, "/arquillian/container/configuration/property", String.format("-Djavax.net.ssl.trustStore=${classpath(%s)}", element));
    }

    @Test
    public void should_not_replace_other_placeholders() throws Exception {
        ContainerDef desc = this.create().container("daemon").property("javaVmArguments", "-Djavax.net.ssl.trustStore=${env.LAUNCHER_TESTS_TRUSTSTORE_PATH}");
        ClasspathConfigurationPlaceholderResolver classpathConfigurationPlaceholderResolver = new ClasspathConfigurationPlaceholderResolver();
        desc = classpathConfigurationPlaceholderResolver.resolve((ArquillianDescriptor)desc);
        String descString = desc.exportAsString();
        AssertXPath.assertXPath(descString, "/arquillian/container/configuration/property", "-Djavax.net.ssl.trustStore=${env.LAUNCHER_TESTS_TRUSTSTORE_PATH}");
    }

    private ArquillianDescriptor create() {
        return (ArquillianDescriptor)Descriptors.create(ArquillianDescriptor.class);
    }
}

