/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.config.impl.extension;

import java.net.URL;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.impl.AssertXPath;
import org.jboss.arquillian.config.impl.extension.AbstractReplacementInArqXmlTestBase;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class ClasspathReplacementInArqXmlTestCase
extends AbstractReplacementInArqXmlTestBase {
    private static final String NAME_ARQ_XML = "arquillian_classpathprop.xml";
    private static final String SYSPROP_ARQ_CONTAINER = "arquillian.container";
    private static final String VALUE_EL_OVERRIDE = "ALR";

    @BeforeClass
    public static void setSysprops() {
        System.setProperty("arquillian.xml", NAME_ARQ_XML);
        System.setProperty(SYSPROP_ARQ_CONTAINER, VALUE_EL_OVERRIDE);
    }

    @AfterClass
    public static void clearSysprops() {
        System.clearProperty("arquillian.xml");
        System.clearProperty(SYSPROP_ARQ_CONTAINER);
    }

    @Test
    public void should_replace_classpath_in_arquillian_xml() throws Exception {
        String xml = ((ArquillianDescriptor)this.desc.get()).exportAsString();
        AssertXPath.assertXPath(xml, "/arquillian/container/@qualifier", VALUE_EL_OVERRIDE);
        URL resource = Thread.currentThread().getContextClassLoader().getResource("arquillian_sysprop.xml");
        AssertXPath.assertXPath(xml, "/arquillian/container/configuration/property", String.format("-Djavax.net.ssl.trustStore=%s", resource.toString()));
    }
}

