/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.impl;

import junit.framework.Assert;
import org.jboss.arquillian.config.descriptor.impl.ContainerDefImpl;
import org.jboss.arquillian.container.impl.LocalContainerRegistry;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.deployment.TargetDescription;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ContainerRegistryTestCase {
    private static final String ARQUILLIAN_XML = "arquillian.xml";
    @Mock
    private ServiceLoader serviceLoader;
    @Mock
    private DeployableContainer<DummyContainerConfiguration> deployableContainer;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.serviceLoader.onlyOne((Class)Mockito.same(DeployableContainer.class))).thenReturn(this.deployableContainer);
        Mockito.when((Object)this.deployableContainer.getConfigurationClass()).thenReturn(DummyContainerConfiguration.class);
    }

    @Test
    public void shouldBeAbleToDefaultTargetToOnlyRegisteredContainer() throws Exception {
        String name = "some-name";
        LocalContainerRegistry registry = new LocalContainerRegistry();
        registry.create(new ContainerDefImpl(ARQUILLIAN_XML).setContainerName(name), this.serviceLoader);
        Container container = registry.getContainer(TargetDescription.DEFAULT);
        Assert.assertEquals((String)"Verify that the only registered container is returned as default", (String)name, (String)container.getName());
    }

    @Test
    public void shouldBeAbleToDefaultTargetToDefaultRegisteredContainer() throws Exception {
        String name = "some-name";
        LocalContainerRegistry registry = new LocalContainerRegistry();
        registry.create(new ContainerDefImpl(ARQUILLIAN_XML).setContainerName("some-other-name"), this.serviceLoader);
        registry.create(new ContainerDefImpl(ARQUILLIAN_XML).setContainerName(name).setDefault(), this.serviceLoader);
        Container container = registry.getContainer(TargetDescription.DEFAULT);
        Assert.assertEquals((String)"Verify that the default registered container is returned as default", (String)name, (String)container.getName());
    }

    @Test
    public void shouldBeAbleToCreateContainerConfiguration() throws Exception {
        String name = "some-name";
        String prop = "prop-value";
        LocalContainerRegistry registry = new LocalContainerRegistry();
        registry.create(new ContainerDefImpl(ARQUILLIAN_XML).setContainerName(name).property("property", prop), this.serviceLoader);
        Container container = registry.getContainer(new TargetDescription(name));
        Assert.assertEquals((String)"Verify that the only registered container is returned as default", (String)name, (String)container.getName());
        Assert.assertEquals((String)"Verify that the configuration was populated", (String)prop, (String)((DummyContainerConfiguration)container.createDeployableConfiguration()).getProperty());
    }

    @Test
    public void shouldBeAbleToSpecifyTarget() throws Exception {
        String name = "some-name";
        LocalContainerRegistry registry = new LocalContainerRegistry();
        registry.create(new ContainerDefImpl(ARQUILLIAN_XML).setContainerName("other-name"), this.serviceLoader);
        registry.create(new ContainerDefImpl(ARQUILLIAN_XML).setContainerName(name), this.serviceLoader);
        Container container = registry.getContainer(new TargetDescription(name));
        Assert.assertEquals((String)"Verify that the specific registered container is returned", (String)name, (String)container.getName());
    }

    @Test
    public void shouldBeAbleToGetContainerByName() throws Exception {
        String name = "some-name";
        LocalContainerRegistry registry = new LocalContainerRegistry();
        registry.create(new ContainerDefImpl(ARQUILLIAN_XML).setContainerName("other-name"), this.serviceLoader);
        registry.create(new ContainerDefImpl(ARQUILLIAN_XML).setContainerName(name), this.serviceLoader);
        Container container = registry.getContainer(name);
        Assert.assertEquals((String)"Verify that the specific registered container is returned", (String)name, (String)container.getName());
    }

    public static class DummyContainerConfiguration
    implements ContainerConfiguration {
        private String property;

        public void setProperty(String property) {
            this.property = property;
        }

        public String getProperty() {
            return this.property;
        }

        public void validate() throws ConfigurationException {
        }
    }
}

