/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.impl.client.container;

import java.util.List;
import org.jboss.arquillian.config.descriptor.api.ContainerDef;
import org.jboss.arquillian.container.impl.LocalContainerRegistry;
import org.jboss.arquillian.container.impl.client.ContainerDeploymentContextHandler;
import org.jboss.arquillian.container.impl.client.container.ContainerDeployController;
import org.jboss.arquillian.container.impl.client.container.ContainerLifecycleControllerTestCase;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentScenario;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentTargetDescription;
import org.jboss.arquillian.container.spi.client.deployment.TargetDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.context.ContainerContext;
import org.jboss.arquillian.container.spi.context.DeploymentContext;
import org.jboss.arquillian.container.spi.event.DeployDeployment;
import org.jboss.arquillian.container.spi.event.DeployManagedDeployments;
import org.jboss.arquillian.container.spi.event.UnDeployDeployment;
import org.jboss.arquillian.container.spi.event.UnDeployManagedDeployments;
import org.jboss.arquillian.container.spi.event.container.AfterDeploy;
import org.jboss.arquillian.container.spi.event.container.AfterUnDeploy;
import org.jboss.arquillian.container.spi.event.container.BeforeDeploy;
import org.jboss.arquillian.container.spi.event.container.BeforeUnDeploy;
import org.jboss.arquillian.container.test.AbstractContainerTestBase;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.spec.cdi.beans.BeansDescriptor;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=MockitoJUnitRunner.class)
public class ContainerDeployControllerTestCase
extends AbstractContainerTestBase {
    private static final String CONTAINER_1_NAME = "container_1";
    private static final String CONTAINER_2_NAME = "container_2";
    private static final String DEPLOYMENT_1_NAME = "deployment_1";
    private static final String DEPLOYMENT_2_NAME = "deployment_2";
    private static final String DEPLOYMENT_3_NAME = "deployment_3_manual";
    private static final String DEPLOYMENT_4_NAME = "deployment_4_descriptor";
    @Mock
    private ServiceLoader serviceLoader;
    @Mock
    private ContainerDef container1;
    @Mock
    private ContainerDef container2;
    @Mock
    private DeployableContainer deployableContainer1;
    @Mock
    private DeployableContainer deployableContainer2;
    @Mock
    private ProtocolMetaData protocolMetaData;
    private ContainerRegistry registry = new LocalContainerRegistry();
    private DeploymentScenario scenario = new DeploymentScenario();

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.deployableContainer1.deploy((Archive)Matchers.isA(Archive.class))).thenReturn((Object)this.protocolMetaData);
        Mockito.when((Object)this.deployableContainer1.getConfigurationClass()).thenReturn(ContainerLifecycleControllerTestCase.DummyContainerConfiguration.class);
        Mockito.when((Object)this.deployableContainer2.deploy((Archive)Matchers.isA(Archive.class))).thenReturn((Object)this.protocolMetaData);
        Mockito.when((Object)this.deployableContainer2.getConfigurationClass()).thenReturn(ContainerLifecycleControllerTestCase.DummyContainerConfiguration.class);
        Mockito.when((Object)this.serviceLoader.onlyOne((Class)Matchers.eq(DeployableContainer.class))).thenReturn((Object)this.deployableContainer1, (Object[])new DeployableContainer[]{this.deployableContainer2});
        Mockito.when((Object)this.container1.getContainerName()).thenReturn((Object)CONTAINER_1_NAME);
        Mockito.when((Object)this.container2.getContainerName()).thenReturn((Object)CONTAINER_2_NAME);
        this.scenario.addDeployment(new DeploymentDescription(DEPLOYMENT_1_NAME, (Archive)ShrinkWrap.create(JavaArchive.class)).setTarget(new TargetDescription(CONTAINER_1_NAME)).shouldBeTestable(false).setOrder(2));
        this.scenario.addDeployment(new DeploymentDescription(DEPLOYMENT_2_NAME, (Archive)ShrinkWrap.create(JavaArchive.class)).setTarget(new TargetDescription(CONTAINER_2_NAME)).setOrder(1).shouldBeTestable(true).setTestableArchive((Archive)ShrinkWrap.create(JavaArchive.class)));
        this.scenario.addDeployment(new DeploymentDescription(DEPLOYMENT_3_NAME, (Archive)ShrinkWrap.create(JavaArchive.class)).setTarget(new TargetDescription(CONTAINER_2_NAME)).setOrder(3).shouldBeTestable(false).shouldBeManaged(false));
        this.scenario.addDeployment(new DeploymentDescription(DEPLOYMENT_4_NAME, Descriptors.create(BeansDescriptor.class)).setTarget(new TargetDescription(CONTAINER_1_NAME)).setOrder(4).shouldBeManaged(true));
        this.bind(ApplicationScoped.class, ContainerRegistry.class, this.registry);
        this.bind(ApplicationScoped.class, DeploymentScenario.class, this.scenario);
    }

    protected void addExtensions(List<Class<?>> extensions) {
        extensions.add(ContainerDeployController.class);
        extensions.add(ContainerDeploymentContextHandler.class);
    }

    @Test
    public void shouldDeployAllManagedDeployments() throws Exception {
        this.registry.create(this.container1, this.serviceLoader);
        this.registry.create(this.container2, this.serviceLoader);
        this.fire(new DeployManagedDeployments());
        this.assertEventFired(DeployDeployment.class, 3);
        this.assertEventFiredInContext(DeployDeployment.class, ContainerContext.class);
        this.assertEventFiredInContext(DeployDeployment.class, DeploymentContext.class);
        this.assertEventFired(BeforeDeploy.class, 3);
        this.assertEventFiredInContext(BeforeDeploy.class, ContainerContext.class);
        this.assertEventFiredInContext(BeforeDeploy.class, DeploymentContext.class);
        this.assertEventFired(AfterDeploy.class, 3);
        this.assertEventFiredInContext(AfterDeploy.class, ContainerContext.class);
        this.assertEventFiredInContext(AfterDeploy.class, DeploymentContext.class);
        ((DeployableContainer)Mockito.verify((Object)this.deployableContainer1, (VerificationMode)Mockito.times((int)1))).deploy((Archive)Matchers.isA(Archive.class));
        ((DeployableContainer)Mockito.verify((Object)this.deployableContainer1, (VerificationMode)Mockito.times((int)1))).deploy((Descriptor)Matchers.isA(Descriptor.class));
        ((DeployableContainer)Mockito.verify((Object)this.deployableContainer2, (VerificationMode)Mockito.times((int)1))).deploy((Archive)Matchers.isA(Archive.class));
        InOrder ordered = Mockito.inOrder((Object[])new Object[]{this.deployableContainer1, this.deployableContainer2});
        ((DeployableContainer)ordered.verify((Object)this.deployableContainer2, Mockito.times((int)1))).deploy(this.scenario.deployment(new DeploymentTargetDescription(DEPLOYMENT_2_NAME)).getDescription().getTestableArchive());
        ((DeployableContainer)ordered.verify((Object)this.deployableContainer1, Mockito.times((int)1))).deploy(this.scenario.deployment(new DeploymentTargetDescription(DEPLOYMENT_1_NAME)).getDescription().getArchive());
        ((DeployableContainer)ordered.verify((Object)this.deployableContainer1, Mockito.times((int)1))).deploy(this.scenario.deployment(new DeploymentTargetDescription(DEPLOYMENT_4_NAME)).getDescription().getDescriptor());
    }

    @Test
    public void shouldUnDeployAllManagedDeployments() throws Exception {
        this.registry.create(this.container1, this.serviceLoader);
        this.registry.create(this.container2, this.serviceLoader);
        this.scenario.deployment(new DeploymentTargetDescription(DEPLOYMENT_3_NAME)).deployed();
        this.fire(new UnDeployManagedDeployments());
        this.assertEventFired(UnDeployDeployment.class, 4);
        this.assertEventFiredInContext(UnDeployDeployment.class, ContainerContext.class);
        this.assertEventFiredInContext(UnDeployDeployment.class, DeploymentContext.class);
        this.assertEventFired(BeforeUnDeploy.class, 4);
        this.assertEventFiredInContext(BeforeUnDeploy.class, ContainerContext.class);
        this.assertEventFiredInContext(BeforeUnDeploy.class, DeploymentContext.class);
        this.assertEventFired(AfterUnDeploy.class, 4);
        this.assertEventFiredInContext(AfterUnDeploy.class, ContainerContext.class);
        this.assertEventFiredInContext(AfterUnDeploy.class, DeploymentContext.class);
        ((DeployableContainer)Mockito.verify((Object)this.deployableContainer1, (VerificationMode)Mockito.times((int)1))).undeploy((Archive)Matchers.isA(Archive.class));
        ((DeployableContainer)Mockito.verify((Object)this.deployableContainer1, (VerificationMode)Mockito.times((int)1))).undeploy((Descriptor)Matchers.isA(Descriptor.class));
        ((DeployableContainer)Mockito.verify((Object)this.deployableContainer2, (VerificationMode)Mockito.times((int)2))).undeploy((Archive)Matchers.isA(Archive.class));
        InOrder ordered = Mockito.inOrder((Object[])new Object[]{this.deployableContainer1, this.deployableContainer2});
        ((DeployableContainer)ordered.verify((Object)this.deployableContainer1, Mockito.times((int)1))).undeploy(this.scenario.deployment(new DeploymentTargetDescription(DEPLOYMENT_4_NAME)).getDescription().getDescriptor());
        ((DeployableContainer)ordered.verify((Object)this.deployableContainer2, Mockito.times((int)1))).undeploy(this.scenario.deployment(new DeploymentTargetDescription(DEPLOYMENT_3_NAME)).getDescription().getArchive());
        ((DeployableContainer)ordered.verify((Object)this.deployableContainer1, Mockito.times((int)1))).undeploy(this.scenario.deployment(new DeploymentTargetDescription(DEPLOYMENT_1_NAME)).getDescription().getArchive());
        ((DeployableContainer)ordered.verify((Object)this.deployableContainer2, Mockito.times((int)1))).undeploy(this.scenario.deployment(new DeploymentTargetDescription(DEPLOYMENT_2_NAME)).getDescription().getTestableArchive());
    }

    @Test
    public void shouldCatchExceptionInDeploymentContext() throws Exception {
        block2: {
            this.registry.create(this.container1, this.serviceLoader);
            this.registry.create(this.container2, this.serviceLoader);
            Mockito.when((Object)this.deployableContainer1.deploy((Archive)Matchers.isA(Archive.class))).thenThrow(new Throwable[]{new DeploymentException("_TEST_")});
            try {
                this.fire(new DeployManagedDeployments());
            }
            catch (Exception e) {
                if (e instanceof DeploymentException) break block2;
                throw e;
            }
        }
        this.assertEventFired(DeploymentException.class, 1);
        this.assertEventFiredInContext(DeploymentException.class, ContainerContext.class);
        this.assertEventFiredInContext(DeploymentException.class, DeploymentContext.class);
        this.assertEventFiredTyped(Throwable.class, 1);
    }
}

