/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.impl.client.container;

import java.util.List;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.container.impl.client.container.ContainerRegistryCreator;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.test.AbstractContainerTestBase;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=MockitoJUnitRunner.class)
public class ContainerRegistryCreatorTestCase
extends AbstractContainerTestBase {
    private static final String CONTAINER_1 = "container_1";
    private static final String CONTAINER_2 = "container_2";
    private static final String GROUP_1 = "group_1";
    private static final String GROUP_2 = "group_2";
    @Inject
    private Instance<ContainerRegistry> regInst;
    @Mock
    private ServiceLoader serviceLoader;
    @Mock
    private DeployableContainer<?> deployableContainer;

    @Before
    public void addServiceLoader() {
        Mockito.when((Object)this.serviceLoader.onlyOne(DeployableContainer.class)).thenReturn(this.deployableContainer);
        this.bind(ApplicationScoped.class, ServiceLoader.class, this.serviceLoader);
    }

    protected void addExtensions(List<Class<?>> extensions) {
        extensions.add(ContainerRegistryCreator.class);
    }

    @Test
    public void shouldRegisterDefaultContainer() {
        this.fire(((ArquillianDescriptor)Descriptors.create(ArquillianDescriptor.class)).container(CONTAINER_1));
        this.verifyRegistry("default");
    }

    @Test
    public void shouldRegisterContainerMarkedDefault() {
        this.fire(((ArquillianDescriptor)Descriptors.create(ArquillianDescriptor.class)).container(CONTAINER_1).setDefault());
        this.verifyRegistry(CONTAINER_1);
    }

    @Test
    public void shouldRegisterContainerMarkedDefaultWhenMultipleDefined() {
        this.fire(((ArquillianDescriptor)Descriptors.create(ArquillianDescriptor.class)).container(CONTAINER_1).setDefault().container(CONTAINER_2));
        this.verifyRegistry(CONTAINER_1);
    }

    @Test
    public void shouldRegisterGroupMarkedDefault() {
        this.fire(((ArquillianDescriptor)Descriptors.create(ArquillianDescriptor.class)).group(GROUP_1).setGroupDefault().container(CONTAINER_1));
        this.verifyRegistry(CONTAINER_1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldRegisterContainerDefinedBySystemProperty() {
        System.setProperty("arquillian.launch", CONTAINER_1);
        try {
            this.fire(((ArquillianDescriptor)Descriptors.create(ArquillianDescriptor.class)).container(CONTAINER_1).group(GROUP_1).setGroupDefault().container(CONTAINER_2));
            this.verifyRegistry(CONTAINER_1);
        }
        finally {
            System.setProperty("arquillian.launch", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldRegisterGroupDefinedBySystemProperty() {
        System.setProperty("arquillian.launch", GROUP_1);
        try {
            this.fire(((ArquillianDescriptor)Descriptors.create(ArquillianDescriptor.class)).container(CONTAINER_1).setDefault().group(GROUP_1).container(CONTAINER_2));
            this.verifyRegistry(CONTAINER_2);
        }
        finally {
            System.setProperty("arquillian.launch", "");
        }
    }

    @Test
    public void shouldThrowExceptionIfMultipleContainersSetAsDefault() {
        try {
            this.fire(((ArquillianDescriptor)Descriptors.create(ArquillianDescriptor.class)).container(CONTAINER_1).setDefault().container(CONTAINER_2).setDefault());
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Multiple Containers defined as default"));
        }
    }

    @Test
    public void shouldThrowExceptionIfMultipleGroupsSetAsDefault() {
        try {
            this.fire(((ArquillianDescriptor)Descriptors.create(ArquillianDescriptor.class)).group(GROUP_1).setGroupDefault().group(GROUP_2).setGroupDefault());
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Multiple Groups defined as default"));
        }
    }

    @Test
    public void shouldThrowExceptionIfMultipleGroupsOrContainersSetAsDefault() {
        try {
            this.fire(((ArquillianDescriptor)Descriptors.create(ArquillianDescriptor.class)).container(CONTAINER_1).setDefault().group(GROUP_1).setGroupDefault());
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Multiple Containers/Groups defined as default"));
        }
    }

    @Test
    public void shouldThrowExceptionIfMultipleContainersInGroupSetAsDefault() {
        try {
            this.fire(((ArquillianDescriptor)Descriptors.create(ArquillianDescriptor.class)).group(GROUP_1).container(CONTAINER_1).setDefault().container(CONTAINER_2).setDefault());
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Multiple Containers within Group defined as default"));
        }
    }

    private void verifyRegistry(String ... containerNames) {
        ContainerRegistry registry = (ContainerRegistry)this.regInst.get();
        Assert.assertNotNull((String)"Verify Containers registered", (Object)registry.getContainers());
        Assert.assertEquals((String)("Verify " + containerNames.length + " Container(s) registrered"), (long)containerNames.length, (long)registry.getContainers().size());
        for (int i = 0; i < containerNames.length; ++i) {
            String containerName = containerNames[i];
            Assert.assertEquals((String)"Verify correct Container registrered", (Object)containerName, (Object)((Container)registry.getContainers().get(i)).getName());
        }
    }
}

