/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.impl.client.container;

import java.util.List;
import java.util.concurrent.Callable;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.deployment.Deployment;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentScenario;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.context.annotation.DeploymentScoped;
import org.jboss.arquillian.container.spi.event.DeployDeployment;
import org.jboss.arquillian.container.spi.event.DeployManagedDeployments;
import org.jboss.arquillian.container.spi.event.DeploymentEvent;
import org.jboss.arquillian.container.spi.event.UnDeployDeployment;
import org.jboss.arquillian.container.spi.event.UnDeployManagedDeployments;
import org.jboss.arquillian.container.spi.event.container.AfterDeploy;
import org.jboss.arquillian.container.spi.event.container.AfterUnDeploy;
import org.jboss.arquillian.container.spi.event.container.BeforeDeploy;
import org.jboss.arquillian.container.spi.event.container.BeforeUnDeploy;
import org.jboss.arquillian.container.spi.event.container.DeployerEvent;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerDeployController {
    @Inject
    private Instance<ContainerRegistry> containerRegistry;
    @Inject
    private Instance<DeploymentScenario> deploymentScenario;
    @Inject
    private Instance<Injector> injector;

    public void deployManaged(@Observes DeployManagedDeployments event) throws Exception {
        this.forEachManagedDeployment(new Operation<Container, Deployment>(){
            @Inject
            private Event<DeploymentEvent> event;

            @Override
            public void perform(Container container, Deployment deployment) throws Exception {
                if (!"manual".equals(container.getContainerConfiguration().getMode())) {
                    this.event.fire((Object)new DeployDeployment(container, deployment));
                }
            }
        });
    }

    public void undeployManaged(@Observes UnDeployManagedDeployments event) throws Exception {
        this.forEachDeployedDeployment(new Operation<Container, Deployment>(){
            @Inject
            private Event<DeploymentEvent> event;

            @Override
            public void perform(Container container, Deployment deployment) throws Exception {
                if (container.getState().equals((Object)Container.State.STARTED) && deployment.isDeployed()) {
                    this.event.fire((Object)new UnDeployDeployment(container, deployment));
                }
            }
        });
    }

    public void deploy(final @Observes DeployDeployment event) throws Exception {
        this.executeOperation(new Callable<Void>(){
            @Inject
            private Event<DeployerEvent> deployEvent;
            @Inject
            @DeploymentScoped
            private InstanceProducer<DeploymentDescription> deploymentDescriptionProducer;
            @Inject
            @DeploymentScoped
            private InstanceProducer<Deployment> deploymentProducer;
            @Inject
            @DeploymentScoped
            private InstanceProducer<ProtocolMetaData> protocolMetadata;

            @Override
            public Void call() throws Exception {
                DeployableContainer deployableContainer = event.getDeployableContainer();
                Deployment deployment = event.getDeployment();
                DeploymentDescription deploymentDescription = deployment.getDescription();
                this.deploymentDescriptionProducer.set((Object)deploymentDescription);
                this.deploymentProducer.set((Object)deployment);
                this.deployEvent.fire((Object)new BeforeDeploy(deployableContainer, deploymentDescription));
                try {
                    if (deploymentDescription.isArchiveDeployment()) {
                        this.protocolMetadata.set((Object)deployableContainer.deploy(deploymentDescription.getTestableArchive() != null ? deploymentDescription.getTestableArchive() : deploymentDescription.getArchive()));
                    } else {
                        deployableContainer.deploy(deploymentDescription.getDescriptor());
                    }
                    deployment.deployed();
                }
                catch (Exception e) {
                    deployment.deployedWithError((Throwable)e);
                    throw e;
                }
                this.deployEvent.fire((Object)new AfterDeploy(deployableContainer, deploymentDescription));
                return null;
            }
        });
    }

    public void undeploy(final @Observes UnDeployDeployment event) throws Exception {
        this.executeOperation(new Callable<Void>(){
            @Inject
            private Event<DeployerEvent> deployEvent;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                DeploymentDescription description;
                DeployableContainer deployableContainer;
                block7: {
                    deployableContainer = event.getDeployableContainer();
                    Deployment deployment = event.getDeployment();
                    description = deployment.getDescription();
                    this.deployEvent.fire((Object)new BeforeUnDeploy(deployableContainer, description));
                    try {
                        if (deployment.getDescription().isArchiveDeployment()) {
                            try {
                                deployableContainer.undeploy(description.getTestableArchive() != null ? description.getTestableArchive() : description.getArchive());
                                break block7;
                            }
                            catch (Exception e) {
                                if (!deployment.hasDeploymentError()) {
                                    throw e;
                                }
                                break block7;
                            }
                        }
                        deployableContainer.undeploy(description.getDescriptor());
                    }
                    finally {
                        deployment.undeployed();
                    }
                }
                this.deployEvent.fire((Object)new AfterUnDeploy(deployableContainer, description));
                return null;
            }
        });
    }

    private void forEachManagedDeployment(Operation<Container, Deployment> operation) throws Exception {
        DeploymentScenario scenario = (DeploymentScenario)this.deploymentScenario.get();
        if (scenario == null) {
            return;
        }
        this.forEachDeployment(scenario.managedDeploymentsInDeployOrder(), operation);
    }

    private void forEachDeployedDeployment(Operation<Container, Deployment> operation) throws Exception {
        DeploymentScenario scenario = (DeploymentScenario)this.deploymentScenario.get();
        if (scenario == null) {
            return;
        }
        this.forEachDeployment(scenario.deployedDeploymentsInUnDeployOrder(), operation);
    }

    private void forEachDeployment(List<Deployment> deployments, Operation<Container, Deployment> operation) throws Exception {
        ((Injector)this.injector.get()).inject(operation);
        ContainerRegistry containerRegistry = (ContainerRegistry)this.containerRegistry.get();
        if (containerRegistry == null) {
            return;
        }
        for (Deployment deployment : deployments) {
            Container container = containerRegistry.getContainer(deployment.getDescription().getTarget());
            operation.perform(container, deployment);
        }
    }

    private void executeOperation(Callable<Void> operation) throws Exception {
        ((Injector)this.injector.get()).inject(operation);
        operation.call();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Operation<T, X> {
        public void perform(T var1, X var2) throws Exception;
    }
}

