/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.impl.client.deployment;

import java.io.File;
import java.util.List;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.container.impl.client.deployment.ArchiveDeploymentExporter;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.container.spi.client.deployment.TargetDescription;
import org.jboss.arquillian.container.spi.event.container.BeforeDeploy;
import org.jboss.arquillian.container.test.AbstractContainerTestBase;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.webapp30.WebAppDescriptor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=MockitoJUnitRunner.class)
public class ArchiveDeploymentExporterTestCase
extends AbstractContainerTestBase {
    private static final String ARQUILLIAN_DEPLOYMENT_EXPORT_PATH = "arquillian.deploymentExportPath";
    private static final String TARGET_NAME = "test.jar";
    private static final String DEPLOYMENT_NAME = "test.jar";
    private static final String ARCHIVE_NAME = "test.jar";
    private static final String EXPORT_PATH = "target/";
    @Mock
    private DeployableContainer<?> deployableContainer;
    @Mock
    private DeploymentDescription deployment;

    protected void addExtensions(List<Class<?>> extensions) {
        extensions.add(ArchiveDeploymentExporter.class);
    }

    @Before
    public void createDeployment() {
        Archive archive = ((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar")).addClass(((Object)((Object)this)).getClass());
        this.deployment = new DeploymentDescription("test.jar", archive);
        this.deployment.setTarget(new TargetDescription("test.jar"));
        this.deployment.setTestableArchive(archive);
    }

    @Test
    public void shouldHandleNoConfigurationInContext() throws Exception {
        this.fire(new BeforeDeploy(this.deployableContainer, this.deployment));
        this.fileShouldExist(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldExportIfExportPathSystemPropertyIsSet() throws Exception {
        System.setProperty(ARQUILLIAN_DEPLOYMENT_EXPORT_PATH, EXPORT_PATH);
        try {
            this.bind(ApplicationScoped.class, ArquillianDescriptor.class, Descriptors.create(ArquillianDescriptor.class));
            this.fire(new BeforeDeploy(this.deployableContainer, this.deployment));
            this.fileShouldExist(true);
        }
        finally {
            System.setProperty(ARQUILLIAN_DEPLOYMENT_EXPORT_PATH, "");
        }
    }

    @Test
    public void shouldNotExportIfDeploymentExportPathNotSet() throws Exception {
        this.bind(ApplicationScoped.class, ArquillianDescriptor.class, Descriptors.create(ArquillianDescriptor.class));
        this.fire(new BeforeDeploy(this.deployableContainer, this.deployment));
        this.fileShouldExist(false);
    }

    @Test
    public void shouldNotExportedIfDeploymentIsNotArchive() throws Exception {
        this.bind(ApplicationScoped.class, ArquillianDescriptor.class, ((ArquillianDescriptor)Descriptors.create(ArquillianDescriptor.class)).engine().deploymentExportPath(EXPORT_PATH));
        this.deployment = new DeploymentDescription("test.jar", Descriptors.create(WebAppDescriptor.class));
        this.deployment.setTarget(new TargetDescription("test.jar"));
        this.fire(new BeforeDeploy(this.deployableContainer, this.deployment));
        this.fileShouldExist(false);
    }

    @Test
    public void shouldBeExportedWhenDeploymentExportPathIsSet() throws Exception {
        this.bind(ApplicationScoped.class, ArquillianDescriptor.class, ((ArquillianDescriptor)Descriptors.create(ArquillianDescriptor.class)).engine().deploymentExportPath(EXPORT_PATH));
        this.fire(new BeforeDeploy(this.deployableContainer, this.deployment));
        this.fileShouldExist(true);
    }

    private void fileShouldExist(boolean bol) {
        File file = new File("target/test.jar_test.jar_test.jar");
        Assert.assertEquals((String)"File exists", (Object)bol, (Object)file.exists());
        file.delete();
    }
}

