/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.impl;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import org.jboss.arquillian.container.impl.MapObject;
import org.junit.Test;

public class MapObjectTestCase {
    private static final String VAL_STRING = "test123";
    private static final Integer VAL_INTEGER = 123;
    private static final Boolean VAL_BOOLEAN = true;
    private static final Double VAL_DOUBLE = 3.4;

    @Test
    public void shouldBeAbleToSetString() throws Exception {
        TestObject test = new TestObject();
        MapObject.populate((Object)test, (Map)this.map("s", VAL_STRING));
        Assert.assertEquals((String)VAL_STRING, (String)test.s);
    }

    @Test
    public void shouldBeAbleToSetInteger() throws Exception {
        TestObject test = new TestObject();
        MapObject.populate((Object)test, (Map)this.map("i", VAL_INTEGER));
        Assert.assertEquals((Object)VAL_INTEGER, (Object)test.i);
    }

    @Test
    public void shouldBeAbleToSetDouble() throws Exception {
        TestObject test = new TestObject();
        MapObject.populate((Object)test, (Map)this.map("d", VAL_DOUBLE));
        Assert.assertEquals((Object)VAL_DOUBLE, (Object)test.d);
    }

    @Test
    public void shouldBeAbleToSetBoolean() throws Exception {
        TestObject test = new TestObject();
        MapObject.populate((Object)test, (Map)this.map("b", VAL_BOOLEAN));
        Assert.assertEquals((Object)VAL_BOOLEAN, (Object)test.b);
    }

    @Test
    public void shouldNotFailOnUnusedOptions() throws Exception {
        TestObject test = new TestObject();
        MapObject.populate((Object)test, (Map)this.map("a", VAL_BOOLEAN));
    }

    private ChainedMap map(String name, Object value) {
        return new ChainedMap().map(name, value);
    }

    public static class TestObject {
        private String s;
        private Integer i;
        private Double d;
        private Boolean b;

        public void setS(String s) {
            this.s = s;
        }

        public void setI(Integer i) {
            this.i = i;
        }

        public void setD(Double d) {
            this.d = d;
        }

        public void setB(Boolean b) {
            this.b = b;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ChainedMap
    extends HashMap<String, String> {
        private static final long serialVersionUID = 8237042898515778650L;

        private ChainedMap() {
        }

        public ChainedMap map(String name, Object value) {
            this.put(name, String.valueOf(value));
            return this;
        }
    }
}

