/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.impl.client.container;

import java.util.Arrays;
import java.util.List;
import org.jboss.arquillian.container.impl.client.container.DeploymentExceptionHandler;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.DeploymentExceptionTransformer;
import org.jboss.arquillian.container.spi.client.deployment.Deployment;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.container.spi.event.DeployDeployment;
import org.jboss.arquillian.container.test.AbstractContainerTestBase;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=MockitoJUnitRunner.class)
public class DeploymentExceptionHandlerTestCase
extends AbstractContainerTestBase {
    @Inject
    @ApplicationScoped
    private InstanceProducer<ServiceLoader> serviceProducer;
    @Mock
    private ServiceLoader serviceLoader;
    @Mock
    private DeploymentExceptionTransformer transformer;
    @Mock
    private Container container;

    protected void addExtensions(List<Class<?>> extensions) {
        extensions.add(DeploymentExceptionHandler.class);
        extensions.add(TestExceptionDeployThrower.class);
    }

    @Before
    public void registerServiceLoader() {
        this.serviceProducer.set((Object)this.serviceLoader);
    }

    @Test
    public void shouldSwallowExceptionIfExpected() throws Exception {
        TestExceptionDeployThrower.shouldThrow = new DeploymentException("Could not handle ba", (Throwable)new NullPointerException());
        this.fire(new DeployDeployment(this.container, new Deployment(new DeploymentDescription("test", (Archive)ShrinkWrap.create(JavaArchive.class)).setExpectedException(NullPointerException.class))));
    }

    @Test
    public void shouldCallDeploymentTransformers() throws Exception {
        TestExceptionDeployThrower.shouldThrow = new DeploymentException("Could not handle ba", (Throwable)new IllegalArgumentException());
        Mockito.when((Object)this.serviceLoader.all(DeploymentExceptionTransformer.class)).thenReturn(Arrays.asList(this.transformer));
        this.fire(new DeployDeployment(this.container, new Deployment(new DeploymentDescription("test", (Archive)ShrinkWrap.create(JavaArchive.class)).setExpectedException(IllegalArgumentException.class))));
        ((DeploymentExceptionTransformer)Mockito.verify((Object)this.transformer, (VerificationMode)Mockito.times((int)1))).transform((Throwable)Mockito.isA(Exception.class));
    }

    @Test
    public void shouldTransformException() throws Exception {
        TestExceptionDeployThrower.shouldThrow = new IllegalStateException();
        Mockito.when((Object)this.serviceLoader.all(DeploymentExceptionTransformer.class)).thenReturn(Arrays.asList(this.transformer));
        Mockito.when((Object)this.transformer.transform(TestExceptionDeployThrower.shouldThrow)).thenReturn((Object)new IllegalArgumentException());
        this.fire(new DeployDeployment(this.container, new Deployment(new DeploymentDescription("test", (Archive)ShrinkWrap.create(JavaArchive.class)).setExpectedException(IllegalArgumentException.class))));
    }

    @Test
    public void shouldSwallawExceptionIfExpectedAndDeploymentExceptionIsFieldOfThrown() throws Exception {
        MyDeploymentException myException = new MyDeploymentException("My special exception", new NullPointerException());
        TestExceptionDeployThrower.shouldThrow = myException;
        Mockito.when((Object)this.serviceLoader.all(DeploymentExceptionTransformer.class)).thenReturn(Arrays.asList(this.transformer));
        Mockito.when((Object)this.transformer.transform(TestExceptionDeployThrower.shouldThrow)).thenReturn((Object)myException.getDeploymentException());
        this.fire(new DeployDeployment(this.container, new Deployment(new DeploymentDescription("test", (Archive)ShrinkWrap.create(JavaArchive.class)).setExpectedException(NullPointerException.class))));
    }

    @Test
    public void shouldSwallawExceptionIfExpectedAndDeploymentExceptionIsFieldOfThrownAndCauseOfOther() throws Exception {
        IllegalArgumentException recursiveException = new IllegalArgumentException(new MyDeploymentException("My special exception", new NullPointerException()));
        TestExceptionDeployThrower.shouldThrow = recursiveException;
        Mockito.when((Object)this.serviceLoader.all(DeploymentExceptionTransformer.class)).thenReturn(Arrays.asList(this.transformer));
        Mockito.when((Object)this.transformer.transform(TestExceptionDeployThrower.shouldThrow)).thenReturn((Object)((MyDeploymentException)recursiveException.getCause()).getDeploymentException());
        this.fire(new DeployDeployment(this.container, new Deployment(new DeploymentDescription("test", (Archive)ShrinkWrap.create(JavaArchive.class)).setExpectedException(NullPointerException.class))));
    }

    @Test(expected=DeploymentException.class)
    public void shouldRethrowExceptionIfWrongExpectedType() throws Exception {
        TestExceptionDeployThrower.shouldThrow = new DeploymentException("Could not handle ba", (Throwable)new NullPointerException());
        Mockito.when((Object)this.serviceLoader.all(DeploymentExceptionTransformer.class)).thenReturn(Arrays.asList(this.transformer));
        this.fire(new DeployDeployment(this.container, new Deployment(new DeploymentDescription("test", (Archive)ShrinkWrap.create(JavaArchive.class)).setExpectedException(IllegalArgumentException.class))));
    }

    @Test(expected=DeploymentException.class)
    public void shouldRethrowExceptionIfExpectedNotSet() throws Exception {
        TestExceptionDeployThrower.shouldThrow = new DeploymentException("Could not handle ba", (Throwable)new NullPointerException());
        this.fire(new DeployDeployment(this.container, new Deployment(new DeploymentDescription("test", (Archive)ShrinkWrap.create(JavaArchive.class)))));
    }

    @Test(expected=RuntimeException.class)
    public void shouldThrowExceptionIfExpectedButNoExceptionThrown() throws Exception {
        TestExceptionDeployThrower.shouldThrow = null;
        this.fire(new DeployDeployment(this.container, new Deployment(new DeploymentDescription("test", (Archive)ShrinkWrap.create(JavaArchive.class)).setExpectedException(IllegalArgumentException.class))));
    }

    public static class TestExceptionDeployThrower {
        public static Throwable shouldThrow = null;

        public void throwException(@Observes DeployDeployment event) throws Throwable {
            if (shouldThrow != null) {
                throw shouldThrow;
            }
        }
    }

    private static class MyDeploymentException
    extends Exception {
        private static final long serialVersionUID = 4864115564504690695L;
        private DeploymentException deploymentException;

        public MyDeploymentException(String message, Throwable cause) {
            super(message);
            this.deploymentException = new DeploymentException("Could not deploy", cause);
        }

        public DeploymentException getDeploymentException() {
            return this.deploymentException;
        }
    }
}

