/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.impl;

import org.jboss.arquillian.config.descriptor.api.ContainerDef;
import org.jboss.arquillian.config.descriptor.impl.ContainerDefImpl;
import org.jboss.arquillian.container.impl.LocalContainerRegistry;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.client.container.ConfigurationMapper;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.deployment.TargetDescription;
import org.jboss.arquillian.container.test.AbstractContainerTestBase;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ContainerRegistryTestCase
extends AbstractContainerTestBase {
    private static final String ARQUILLIAN_XML = "arquillian.xml";
    @Inject
    private Instance<Injector> injector;
    @Mock
    private ServiceLoader serviceLoader;
    @Mock
    private DeployableContainer<DummyContainerConfiguration> deployableContainer;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)((DeployableContainer)this.serviceLoader.onlyOne((Class)Mockito.same(DeployableContainer.class)))).thenReturn(this.deployableContainer);
        Mockito.when((Object)this.deployableContainer.getConfigurationClass()).thenReturn(DummyContainerConfiguration.class);
    }

    @Test
    public void shouldBeAbleToDefaultTargetToOnlyRegisteredContainer() throws Exception {
        String name = "some-name";
        LocalContainerRegistry registry = new LocalContainerRegistry((Injector)this.injector.get());
        registry.create(new ContainerDefImpl(ARQUILLIAN_XML).setContainerName(name), this.serviceLoader);
        Container container = registry.getContainer(TargetDescription.DEFAULT);
        Assert.assertEquals((String)"Verify that the only registered container is returned as default", (Object)name, (Object)container.getName());
    }

    @Test
    public void shouldBeAbleToDefaultTargetToDefaultRegisteredContainer() throws Exception {
        String name = "some-name";
        LocalContainerRegistry registry = new LocalContainerRegistry((Injector)this.injector.get());
        registry.create(new ContainerDefImpl(ARQUILLIAN_XML).setContainerName("some-other-name"), this.serviceLoader);
        registry.create(new ContainerDefImpl(ARQUILLIAN_XML).setContainerName(name).setDefault(), this.serviceLoader);
        Container container = registry.getContainer(TargetDescription.DEFAULT);
        Assert.assertEquals((String)"Verify that the default registered container is returned as default", (Object)name, (Object)container.getName());
    }

    @Test
    public void shouldBeAbleToCreateContainerConfiguration() throws Exception {
        String name = "some-name";
        String prop = "prop-value";
        LocalContainerRegistry registry = new LocalContainerRegistry((Injector)this.injector.get());
        registry.create(new ContainerDefImpl(ARQUILLIAN_XML).setContainerName(name).property("property", prop), this.serviceLoader);
        Container container = registry.getContainer(new TargetDescription(name));
        Assert.assertEquals((String)"Verify that the only registered container is returned as default", (Object)name, (Object)container.getName());
        Assert.assertEquals((String)"Verify that the configuration was populated", (Object)prop, (Object)((DummyContainerConfiguration)container.createDeployableConfiguration()).getProperty());
    }

    @Test
    public void shouldBeAbleToCreatePrivateContainerConfiguration() throws Exception {
        ServiceLoader serviceLoader = (ServiceLoader)Mockito.mock(ServiceLoader.class);
        DeployableContainer deployableContainer = (DeployableContainer)Mockito.mock(DeployableContainer.class);
        Mockito.when((Object)((DeployableContainer)serviceLoader.onlyOne((Class)Mockito.same(DeployableContainer.class)))).thenReturn((Object)deployableContainer);
        Mockito.when((Object)deployableContainer.getConfigurationClass()).thenReturn(PrivateDummyContainerConfiguration.class);
        String name = "some-name";
        String prop = "prop-value";
        LocalContainerRegistry registry = new LocalContainerRegistry((Injector)this.injector.get());
        registry.create(new ContainerDefImpl(ARQUILLIAN_XML).setContainerName(name).property("property", prop), serviceLoader);
        Container container = registry.getContainer(new TargetDescription(name));
        Assert.assertEquals((String)"Verify that the only registered container is returned as default", (Object)name, (Object)container.getName());
        Assert.assertEquals((String)"Verify that the configuration was populated", (Object)prop, (Object)((PrivateDummyContainerConfiguration)container.createDeployableConfiguration()).getProperty());
    }

    @Test
    public void shouldBeAbleToCreateContainerConfigurationCustomMapper() throws Exception {
        ServiceLoader serviceLoader = (ServiceLoader)Mockito.mock(ServiceLoader.class);
        DeployableContainer deployableContainer = (DeployableContainer)Mockito.mock(DeployableContainer.class);
        Mockito.when((Object)((DeployableContainer)serviceLoader.onlyOne((Class)Mockito.same(DeployableContainer.class)))).thenReturn((Object)deployableContainer);
        Mockito.when((Object)deployableContainer.getConfigurationClass()).thenReturn(CustomContainerConfiguration.class);
        Mockito.when((Object)deployableContainer.getConfigurationMapper()).thenReturn((Object)new CustomMapper());
        String name = "custom-container";
        String prop = "prop-value";
        Object[] hosts = new String[]{"host1", "host2", "host3"};
        LocalContainerRegistry registry = new LocalContainerRegistry((Injector)this.injector.get());
        ContainerDefImpl containerDef = new ContainerDefImpl(ARQUILLIAN_XML);
        containerDef.setContainerName(name);
        containerDef.property("property", prop);
        containerDef.property("hosts", "host1,host2,host3");
        registry.create((ContainerDef)containerDef, serviceLoader);
        Container container = registry.getContainer(new TargetDescription(name));
        Assert.assertEquals((String)"Verify that the only registered container is returned as default", (Object)name, (Object)container.getName());
        CustomContainerConfiguration config = (CustomContainerConfiguration)container.createDeployableConfiguration();
        Assert.assertEquals((String)"Verify that the custom configuration 'property' was populated", (Object)prop, (Object)config.getProperty());
        Assert.assertArrayEquals((String)"Verify that the custom configuration 'hosts' was populated", (Object[])hosts, (Object[])config.getHosts());
    }

    @Test
    public void shouldBeAbleToSpecifyTarget() throws Exception {
        String name = "some-name";
        LocalContainerRegistry registry = new LocalContainerRegistry((Injector)this.injector.get());
        registry.create(new ContainerDefImpl(ARQUILLIAN_XML).setContainerName("other-name"), this.serviceLoader);
        registry.create(new ContainerDefImpl(ARQUILLIAN_XML).setContainerName(name), this.serviceLoader);
        Container container = registry.getContainer(new TargetDescription(name));
        Assert.assertEquals((String)"Verify that the specific registered container is returned", (Object)name, (Object)container.getName());
    }

    @Test
    public void shouldBeAbleToGetContainerByName() throws Exception {
        String name = "some-name";
        LocalContainerRegistry registry = new LocalContainerRegistry((Injector)this.injector.get());
        registry.create(new ContainerDefImpl(ARQUILLIAN_XML).setContainerName("other-name"), this.serviceLoader);
        registry.create(new ContainerDefImpl(ARQUILLIAN_XML).setContainerName(name), this.serviceLoader);
        Container container = registry.getContainer(name);
        Assert.assertEquals((String)"Verify that the specific registered container is returned", (Object)name, (Object)container.getName());
    }

    public static class DummyContainerConfiguration
    implements ContainerConfiguration {
        private String property;

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public void validate() throws ConfigurationException {
        }
    }

    private static class PrivateDummyContainerConfiguration
    extends DummyContainerConfiguration {
        private PrivateDummyContainerConfiguration() {
        }
    }

    private static class CustomContainerConfiguration
    extends DummyContainerConfiguration {
        private String[] hosts;

        private CustomContainerConfiguration() {
        }

        public String[] getHosts() {
            return this.hosts;
        }

        public void setHosts(String[] hosts) {
            this.hosts = hosts;
        }
    }

    private static class CustomMapper
    implements ConfigurationMapper<CustomContainerConfiguration> {
        private CustomMapper() {
        }

        public void populateConfiguration(CustomContainerConfiguration containerConfiguration, ContainerDef definition) {
            String property = definition.getContainerProperty("property");
            containerConfiguration.setProperty(property);
            String hostsString = definition.getContainerProperty("hosts");
            String[] hosts = hostsString.split(",");
            containerConfiguration.setHosts(hosts);
        }
    }
}

