/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.impl.client.container;

import java.util.List;
import org.jboss.arquillian.config.descriptor.api.ContainerDef;
import org.jboss.arquillian.container.impl.LocalContainerRegistry;
import org.jboss.arquillian.container.impl.client.ContainerDeploymentContextHandler;
import org.jboss.arquillian.container.impl.client.container.ContainerLifecycleController;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.context.ContainerContext;
import org.jboss.arquillian.container.spi.event.SetupContainer;
import org.jboss.arquillian.container.spi.event.SetupContainers;
import org.jboss.arquillian.container.spi.event.StartClassContainers;
import org.jboss.arquillian.container.spi.event.StartContainer;
import org.jboss.arquillian.container.spi.event.StartSuiteContainers;
import org.jboss.arquillian.container.spi.event.StopClassContainers;
import org.jboss.arquillian.container.spi.event.StopContainer;
import org.jboss.arquillian.container.spi.event.StopSuiteContainers;
import org.jboss.arquillian.container.spi.event.container.AfterSetup;
import org.jboss.arquillian.container.spi.event.container.AfterStart;
import org.jboss.arquillian.container.spi.event.container.AfterStop;
import org.jboss.arquillian.container.spi.event.container.BeforeSetup;
import org.jboss.arquillian.container.spi.event.container.BeforeStart;
import org.jboss.arquillian.container.spi.event.container.BeforeStop;
import org.jboss.arquillian.container.test.AbstractContainerTestBase;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ContainerLifecycleControllerTestCase
extends AbstractContainerTestBase {
    private static final String CONTAINER_1_NAME = "container_1_suite";
    private static final String CONTAINER_2_NAME = "container_2_suite";
    private static final String CONTAINER_3_NAME = "container_3_class";
    private static final String CONTAINER_4_NAME = "container_4_class";
    private static final String CONTAINER_5_NAME = "container_5_custom";
    @Inject
    private Instance<Injector> injector;
    private ContainerRegistry registry;
    @Mock
    private ServiceLoader serviceLoader;
    @Mock
    private ContainerDef container1;
    @Mock
    private ContainerDef container2;
    @Mock
    private ContainerDef container3;
    @Mock
    private ContainerDef container4;
    @Mock
    private ContainerDef container5;
    @Mock
    private DeployableContainer deployableContainer;

    @Before
    public void setup() {
        Mockito.when((Object)this.deployableContainer.getConfigurationClass()).thenReturn(DummyContainerConfiguration.class);
        Mockito.when((Object)((DeployableContainer)this.serviceLoader.onlyOne((Class)ArgumentMatchers.eq(DeployableContainer.class)))).thenReturn((Object)this.deployableContainer);
        Mockito.when((Object)this.container1.getContainerName()).thenReturn((Object)CONTAINER_1_NAME);
        Mockito.when((Object)this.container2.getContainerName()).thenReturn((Object)CONTAINER_2_NAME);
        Mockito.when((Object)this.container3.getContainerName()).thenReturn((Object)CONTAINER_3_NAME);
        Mockito.when((Object)this.container4.getContainerName()).thenReturn((Object)CONTAINER_4_NAME);
        Mockito.when((Object)this.container5.getContainerName()).thenReturn((Object)CONTAINER_5_NAME);
        Mockito.when((Object)this.container1.getMode()).thenReturn((Object)"suite");
        Mockito.when((Object)this.container2.getMode()).thenReturn((Object)"suite");
        Mockito.when((Object)this.container3.getMode()).thenReturn((Object)"class");
        Mockito.when((Object)this.container4.getMode()).thenReturn((Object)"class");
        Mockito.when((Object)this.container5.getMode()).thenReturn((Object)"custom");
        this.registry = new LocalContainerRegistry((Injector)this.injector.get());
        this.bind(ApplicationScoped.class, ContainerRegistry.class, this.registry);
    }

    protected void addExtensions(List<Class<?>> extensions) {
        extensions.add(ContainerLifecycleController.class);
        extensions.add(ContainerDeploymentContextHandler.class);
    }

    @Test
    public void shouldSetupAllContainersInRegistry() throws Exception {
        this.registry.create(this.container1, this.serviceLoader);
        this.registry.create(this.container2, this.serviceLoader);
        this.registry.create(this.container3, this.serviceLoader);
        this.registry.create(this.container4, this.serviceLoader);
        this.registry.create(this.container5, this.serviceLoader);
        this.fire(new SetupContainers());
        this.assertEventFiredInContext(SetupContainer.class, ContainerContext.class);
        this.assertEventFired(SetupContainer.class, 5);
        this.assertEventFiredInContext(BeforeSetup.class, ContainerContext.class);
        this.assertEventFired(BeforeSetup.class, 5);
        this.assertEventFiredInContext(AfterSetup.class, ContainerContext.class);
        this.assertEventFired(AfterSetup.class, 5);
        ((DeployableContainer)Mockito.verify((Object)this.deployableContainer, (VerificationMode)Mockito.times((int)5))).setup((ContainerConfiguration)ArgumentMatchers.isA(DummyContainerConfiguration.class));
    }

    @Test
    public void shouldStartAllSuiteContainersInRegistry() throws Exception {
        this.registry.create(this.container1, this.serviceLoader);
        this.registry.create(this.container2, this.serviceLoader);
        this.registry.create(this.container3, this.serviceLoader);
        this.registry.create(this.container4, this.serviceLoader);
        this.registry.create(this.container5, this.serviceLoader);
        this.fire(new StartSuiteContainers());
        this.assertEventFiredInContext(StartContainer.class, ContainerContext.class);
        this.assertEventFired(StartContainer.class, 2);
        this.assertEventFiredInContext(BeforeStart.class, ContainerContext.class);
        this.assertEventFired(BeforeStart.class, 2);
        this.assertEventFiredInContext(AfterStart.class, ContainerContext.class);
        this.assertEventFired(AfterStart.class, 2);
        ((DeployableContainer)Mockito.verify((Object)this.deployableContainer, (VerificationMode)Mockito.times((int)2))).start();
    }

    @Test
    public void shouldStartAllClassContainersInRegistry() throws Exception {
        this.registry.create(this.container1, this.serviceLoader);
        this.registry.create(this.container2, this.serviceLoader);
        this.registry.create(this.container3, this.serviceLoader);
        this.registry.create(this.container4, this.serviceLoader);
        this.registry.create(this.container5, this.serviceLoader);
        this.fire(new StartClassContainers());
        this.assertEventFiredInContext(StartContainer.class, ContainerContext.class);
        this.assertEventFired(StartContainer.class, 2);
        this.assertEventFiredInContext(BeforeStart.class, ContainerContext.class);
        this.assertEventFired(BeforeStart.class, 2);
        this.assertEventFiredInContext(AfterStart.class, ContainerContext.class);
        this.assertEventFired(AfterStart.class, 2);
        ((DeployableContainer)Mockito.verify((Object)this.deployableContainer, (VerificationMode)Mockito.times((int)2))).start();
    }

    @Test
    public void shouldStopAllSuiteContainersInRegistry() throws Exception {
        this.registry.create(this.container1, this.serviceLoader);
        this.registry.create(this.container2, this.serviceLoader);
        this.registry.create(this.container5, this.serviceLoader);
        for (Container c : this.registry.getContainers()) {
            c.setState(Container.State.STARTED);
        }
        this.fire(new StopSuiteContainers());
        this.assertEventFiredInContext(StopContainer.class, ContainerContext.class);
        this.assertEventFired(StopContainer.class, 2);
        this.assertEventFiredInContext(BeforeStop.class, ContainerContext.class);
        this.assertEventFired(BeforeStop.class, 2);
        this.assertEventFiredInContext(AfterStop.class, ContainerContext.class);
        this.assertEventFired(AfterStop.class, 2);
        ((DeployableContainer)Mockito.verify((Object)this.deployableContainer, (VerificationMode)Mockito.times((int)2))).stop();
    }

    @Test
    public void shouldStopAllClassContainersInRegistry() throws Exception {
        this.registry.create(this.container1, this.serviceLoader);
        this.registry.create(this.container2, this.serviceLoader);
        this.registry.create(this.container3, this.serviceLoader);
        this.registry.create(this.container4, this.serviceLoader);
        this.registry.create(this.container5, this.serviceLoader);
        for (Container c : this.registry.getContainers()) {
            c.setState(Container.State.STARTED);
        }
        this.fire(new StopClassContainers());
        this.assertEventFiredInContext(StopContainer.class, ContainerContext.class);
        this.assertEventFired(StopContainer.class, 2);
        this.assertEventFiredInContext(BeforeStop.class, ContainerContext.class);
        this.assertEventFired(BeforeStop.class, 2);
        this.assertEventFiredInContext(AfterStop.class, ContainerContext.class);
        this.assertEventFired(AfterStop.class, 2);
        ((DeployableContainer)Mockito.verify((Object)this.deployableContainer, (VerificationMode)Mockito.times((int)2))).stop();
    }

    @Test
    public void shouldNotStartCustomContainersInRegistry() throws Exception {
        this.registry.create(this.container5, this.serviceLoader).setState(Container.State.STOPPED);
        this.fire(new SetupContainers());
        ((DeployableContainer)Mockito.verify((Object)this.deployableContainer, (VerificationMode)Mockito.times((int)1))).setup((ContainerConfiguration)ArgumentMatchers.isA(DummyContainerConfiguration.class));
        this.fire(new StartSuiteContainers());
        ((DeployableContainer)Mockito.verify((Object)this.deployableContainer, (VerificationMode)Mockito.times((int)0))).start();
        this.fire(new StartClassContainers());
        ((DeployableContainer)Mockito.verify((Object)this.deployableContainer, (VerificationMode)Mockito.times((int)0))).start();
        Assert.assertEquals((Object)Container.State.SETUP, (Object)this.registry.getContainer(CONTAINER_5_NAME).getState());
    }

    @Test
    public void shouldNotStopCustomContainersInRegistry() throws Exception {
        this.registry.create(this.container5, this.serviceLoader).setState(Container.State.STARTED);
        this.fire(new StopClassContainers());
        ((DeployableContainer)Mockito.verify((Object)this.deployableContainer, (VerificationMode)Mockito.times((int)0))).stop();
        this.fire(new StopSuiteContainers());
        ((DeployableContainer)Mockito.verify((Object)this.deployableContainer, (VerificationMode)Mockito.times((int)0))).stop();
        Assert.assertEquals((Object)Container.State.STARTED, (Object)this.registry.getContainer(CONTAINER_5_NAME).getState());
    }

    public static class DummyContainerConfiguration
    implements ContainerConfiguration {
        public void validate() throws ConfigurationException {
        }
    }
}

