/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.osgi.karaf.embedded;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.karaf.main.Main;
import org.jboss.arquillian.container.osgi.EmbeddedDeployableContainer;
import org.jboss.arquillian.container.osgi.karaf.embedded.KarafEmbeddedContainerConfiguration;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarafEmbeddedDeployableContainer
extends EmbeddedDeployableContainer<KarafEmbeddedContainerConfiguration> {
    static final Logger LOGGER = LoggerFactory.getLogger((String)KarafEmbeddedDeployableContainer.class.getPackage().getName());
    private Main karaf;

    public Class<KarafEmbeddedContainerConfiguration> getConfigurationClass() {
        return KarafEmbeddedContainerConfiguration.class;
    }

    protected KarafEmbeddedContainerConfiguration getContainerConfiguration() {
        return (KarafEmbeddedContainerConfiguration)super.getContainerConfiguration();
    }

    protected Framework createFramework(KarafEmbeddedContainerConfiguration conf) {
        String karafHome = System.getProperty("karaf.home");
        if (karafHome == null && conf.getKarafHome() != null) {
            System.setProperty("karaf.home", conf.getKarafHome());
        }
        this.karaf = new Main(null);
        try {
            this.karaf.launch();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        return this.karaf.getFramework();
    }

    protected BundleContext startFramework() throws BundleException {
        Framework framework = this.karaf.getFramework();
        return framework.getBundleContext();
    }

    protected void stopFramework() throws BundleException {
        try {
            this.karaf.destroy();
        }
        catch (Exception ex) {
            throw new BundleException("Cannot stop Karaf", (Throwable)ex);
        }
    }

    protected void awaitArquillianBundleActive(BundleContext syscontext, long timeout, TimeUnit unit) throws LifecycleException {
        super.awaitArquillianBundleActive(syscontext, timeout, unit);
        KarafEmbeddedContainerConfiguration config = this.getContainerConfiguration();
        Integer beginningStartLevel = config.getKarafBeginningStartLevel();
        if (beginningStartLevel != null) {
            this.awaitKarafBeginningStartLevel(syscontext, beginningStartLevel, timeout, unit);
        }
    }

    protected EmbeddedDeployableContainer.ContainerLogger getLogger() {
        return new EmbeddedDeployableContainer.AbstractContainerLogger(){

            public void log(EmbeddedDeployableContainer.ContainerLogger.Level level, String message, Throwable th) {
                switch (level) {
                    case DEBUG: {
                        LOGGER.debug(message, th);
                        break;
                    }
                    case INFO: {
                        LOGGER.info(message, th);
                        break;
                    }
                    case WARN: {
                        LOGGER.warn(message, th);
                        break;
                    }
                    case ERROR: {
                        LOGGER.error(message, th);
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void awaitKarafBeginningStartLevel(BundleContext syscontext, final Integer beginningStartLevel, long timeout, TimeUnit unit) {
        block6: {
            final CountDownLatch latch = new CountDownLatch(1);
            final FrameworkStartLevel fwrkStartLevel = (FrameworkStartLevel)syscontext.getBundle().adapt(FrameworkStartLevel.class);
            FrameworkListener listener = new FrameworkListener(){

                public void frameworkEvent(FrameworkEvent event) {
                    int startLevel;
                    if (event.getType() == 8 && (startLevel = fwrkStartLevel.getStartLevel()) == beginningStartLevel) {
                        latch.countDown();
                    }
                }
            };
            syscontext.addFrameworkListener(listener);
            try {
                int startLevel = fwrkStartLevel.getStartLevel();
                if (startLevel >= beginningStartLevel) break block6;
                try {
                    if (!latch.await(timeout, unit)) {
                        throw new IllegalStateException("Giving up waiting to reach start level: " + beginningStartLevel);
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            finally {
                syscontext.removeFrameworkListener(listener);
            }
        }
    }
}

