/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.arquillian.container.osgi;

import java.io.InputStream;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.osgi.spi.OSGiManifestBuilder;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

@RunWith(value=Arquillian.class)
public class ARQ193ExplicitTestCase {
    @Inject
    public Bundle bundle;

    @Deployment
    public static Archive<?> createDeployment() {
        final JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"arq139-explicit");
        archive.addClass(ARQ193ExplicitTestCase.class);
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                builder.addBundleSymbolicName(archive.getName());
                builder.addBundleManifestVersion(2);
                builder.addExportPackages(new Class[]{ARQ193ExplicitTestCase.class});
                builder.addImportPackages(new String[]{"org.jboss.arquillian.test.api", "org.jboss.arquillian.junit"});
                builder.addImportPackages(new String[]{"org.jboss.shrinkwrap.api", "org.jboss.shrinkwrap.api.asset", "org.jboss.shrinkwrap.api.spec"});
                builder.addImportPackages(new String[]{"javax.inject", "org.junit", "org.junit.runner", "org.osgi.framework"});
                return builder.openStream();
            }
        });
        return archive;
    }

    @Test
    public void testBundleInjection() throws Exception {
        Assert.assertNotNull((String)"Bundle injected", (Object)this.bundle);
        Assert.assertEquals((String)"Bundle INSTALLED", (long)4L, (long)this.bundle.getState());
        this.bundle.start();
        Assert.assertEquals((String)"Bundle ACTIVE", (long)32L, (long)this.bundle.getState());
        Assert.assertEquals((Object)"arq139-explicit", (Object)this.bundle.getSymbolicName());
        this.bundle.loadClass(ARQ193ExplicitTestCase.class.getName());
        BundleContext context = this.bundle.getBundleContext();
        for (Bundle bundle : context.getBundles()) {
            if (!bundle.getSymbolicName().equals(ARQ193ExplicitTestCase.class.getSimpleName())) continue;
            Assert.fail((String)("Unexpected generated bundle: " + bundle));
        }
        this.bundle.stop();
        Assert.assertEquals((String)"Bundle RESOLVED", (long)4L, (long)this.bundle.getState());
        this.bundle.uninstall();
        Assert.assertEquals((String)"Bundle UNINSTALLED", (long)1L, (long)this.bundle.getState());
    }
}

