/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.arquillian.container.osgi;

import java.io.InputStream;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.osgi.spi.OSGiManifestBuilder;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.test.arquillian.container.osgi.bundle.ARQ194Activator;
import org.jboss.test.arquillian.container.osgi.bundle.ARQ194Service;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

@RunWith(value=Arquillian.class)
public class ARQ194TestCase {
    private static final String BUNDLE_NAME = "arq194-bundle";
    @Inject
    public BundleContext context;
    @ArquillianResource
    public Deployer deployer;

    @Deployment
    public static JavaArchive create() {
        return (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"arq194-test");
    }

    @Test
    public void testInstallBundleFromArchive() throws Exception {
        InputStream input = this.deployer.getDeployment(BUNDLE_NAME);
        Bundle bundle = this.context.installBundle(BUNDLE_NAME, input);
        Assert.assertEquals((String)"Bundle INSTALLED", (long)2L, (long)bundle.getState());
        Assert.assertEquals((Object)BUNDLE_NAME, (Object)bundle.getSymbolicName());
        bundle.start();
        Assert.assertEquals((String)"Bundle ACTIVE", (long)32L, (long)bundle.getState());
        bundle.stop();
        Assert.assertEquals((String)"Bundle RESOLVED", (long)4L, (long)bundle.getState());
        bundle.uninstall();
        Assert.assertEquals((String)"Bundle UNINSTALLED", (long)1L, (long)bundle.getState());
    }

    @Deployment(name="arq194-bundle", managed=false, testable=false)
    public static JavaArchive getTestArchive() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                builder.addBundleSymbolicName(ARQ194TestCase.BUNDLE_NAME);
                builder.addBundleManifestVersion(2);
                builder.addBundleActivator(ARQ194Activator.class.getName());
                builder.addExportPackages(new Class[]{ARQ194Service.class});
                builder.addImportPackages(new Class[]{BundleActivator.class});
                return builder.openStream();
            }
        });
        archive.addClasses(new Class[]{ARQ194Activator.class, ARQ194Service.class});
        return archive;
    }
}

