/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.arquillian.container.osgi;

import java.io.InputStream;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.osgi.spi.OSGiManifestBuilder;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

@RunWith(value=Arquillian.class)
public class ARQ271BeforeTestCase {
    @Inject
    public BundleContext context;
    @Inject
    public Bundle bundle;

    @Deployment
    public static JavaArchive createdeployment() {
        final JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar");
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                builder.addBundleSymbolicName(archive.getName());
                builder.addBundleManifestVersion(2);
                return builder.openStream();
            }
        });
        return archive;
    }

    @Before
    public void before() throws Exception {
        Assert.assertNotNull((String)"BundleContext injected", (Object)this.context);
        Assert.assertEquals((String)"System Bundle ID", (long)0L, (long)this.context.getBundle().getBundleId());
        Assert.assertNotNull((String)"Bundle injected", (Object)this.bundle);
        Assert.assertEquals((long)4L, (long)this.bundle.getState());
    }

    @After
    public void after() throws Exception {
        Assert.assertNotNull((String)"BundleContext injected", (Object)this.context);
        Assert.assertEquals((String)"System Bundle ID", (long)0L, (long)this.context.getBundle().getBundleId());
        Assert.assertNotNull((String)"Bundle injected", (Object)this.bundle);
        Assert.assertEquals((long)4L, (long)this.bundle.getState());
    }

    @Test
    public void testBundleInjection() throws Exception {
        Assert.assertNotNull((String)"BundleContext injected", (Object)this.context);
        Assert.assertEquals((String)"System Bundle ID", (long)0L, (long)this.context.getBundle().getBundleId());
        Assert.assertNotNull((String)"Bundle injected", (Object)this.bundle);
        Assert.assertEquals((long)4L, (long)this.bundle.getState());
    }
}

