/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.arquillian.container.osgi;

import java.io.InputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.osgi.StartLevelAware;
import org.jboss.osgi.spi.OSGiManifestBuilder;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.service.startlevel.StartLevel;

@RunWith(value=Arquillian.class)
public class ARQ465TestCase {
    @Inject
    public Bundle bundle;
    @Inject
    public BundleContext context;
    @Inject
    public StartLevel startLevel;

    @Deployment
    @StartLevelAware(startLevel=3)
    public static JavaArchive create() {
        final JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"arq465-bundle");
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                builder.addBundleSymbolicName(archive.getName());
                builder.addBundleManifestVersion(2);
                builder.addImportPackages(new Class[]{StartLevel.class});
                return builder.openStream();
            }
        });
        return archive;
    }

    @Test
    public void testStartLevel() throws Exception {
        Assert.assertNotNull((String)"StartLevel injected", (Object)this.startLevel);
        int initialStartLevel = this.startLevel.getInitialBundleStartLevel();
        Assert.assertEquals((String)"Initial bundle start level", (long)1L, (long)initialStartLevel);
        Assert.assertEquals((String)"Bundle RESOLVED", (long)4L, (long)this.bundle.getState());
        Assert.assertEquals((Object)"arq465-bundle", (Object)this.bundle.getSymbolicName());
        int bundleStartLevel = this.startLevel.getBundleStartLevel(this.bundle);
        Assert.assertEquals((String)"Bundle start level", (long)3L, (long)bundleStartLevel);
        try {
            this.bundle.start(1);
            Assert.fail((String)"Bundle cannot be started due to the Framework's current start level");
        }
        catch (BundleException ex) {
            // empty catch block
        }
        Assert.assertEquals((String)"Bundle RESOLVED", (long)4L, (long)this.bundle.getState());
        this.bundle.start();
        Assert.assertEquals((String)"Bundle RESOLVED", (long)4L, (long)this.bundle.getState());
        final CountDownLatch latch = new CountDownLatch(1);
        this.context.addFrameworkListener(new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() == 8) {
                    latch.countDown();
                }
            }
        });
        this.startLevel.setStartLevel(3);
        latch.await(3L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"Bundle ACTIVE", (long)32L, (long)this.bundle.getState());
        this.bundle.stop();
        Assert.assertEquals((String)"Bundle RESOLVED", (long)4L, (long)this.bundle.getState());
        this.bundle.uninstall();
        Assert.assertEquals((String)"Bundle UNINSTALLED", (long)1L, (long)this.bundle.getState());
    }
}

