/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.arquillian.container.osgi;

import java.io.InputStream;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.osgi.spi.OSGiManifestBuilder;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

@RunWith(value=Arquillian.class)
public class ARQ466TestCase {
    @Inject
    public Bundle bundle;
    @Inject
    public PackageAdmin packageAdmin;

    @Deployment
    public static JavaArchive create() {
        final JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"arq466-bundle");
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                builder.addBundleSymbolicName(archive.getName());
                builder.addBundleManifestVersion(2);
                builder.addImportPackages(new Class[]{StartLevel.class});
                return builder.openStream();
            }
        });
        return archive;
    }

    @Test
    public void testPackageAdmin() throws Exception {
        Assert.assertNotNull((String)"PackageAdmin injected", (Object)this.packageAdmin);
        Assert.assertEquals((String)"Bundle RESOLVED", (long)4L, (long)this.bundle.getState());
        Assert.assertEquals((Object)"arq466-bundle", (Object)this.bundle.getSymbolicName());
        Bundle[] bundles = this.packageAdmin.getBundles("arq466-bundle", null);
        Assert.assertNotNull((String)"Bundles not null", (Object)bundles);
        Assert.assertEquals((String)"One bundle found", (long)1L, (long)bundles.length);
        Assert.assertEquals((Object)this.bundle, (Object)bundles[0]);
    }
}

