/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.arquillian.container.osgi;

import java.io.InputStream;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.osgi.spi.OSGiManifestBuilder;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.test.arquillian.container.osgi.bundle.SimpleActivator;
import org.jboss.test.arquillian.container.osgi.bundle.SimpleService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

@RunWith(value=Arquillian.class)
public class SimpleBundleTestCase {
    @Inject
    public BundleContext context;
    @Inject
    public Bundle bundle;

    @Deployment
    public static JavaArchive createdeployment() {
        final JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar");
        archive.addClasses(new Class[]{SimpleActivator.class, SimpleService.class});
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                builder.addBundleSymbolicName(archive.getName());
                builder.addBundleManifestVersion(2);
                builder.addBundleActivator(SimpleActivator.class.getName());
                builder.addImportPackages(new Class[]{BundleActivator.class});
                return builder.openStream();
            }
        });
        return archive;
    }

    @Test
    public void testBundleContextInjection() throws Exception {
        Assert.assertNotNull((String)"BundleContext injected", (Object)this.context);
        Assert.assertEquals((String)"System Bundle ID", (long)0L, (long)this.context.getBundle().getBundleId());
    }

    @Test
    public void testBundleInjection() throws Exception {
        Assert.assertNotNull((String)"Bundle injected", (Object)this.bundle);
        Assert.assertEquals((String)"Bundle RESOLVED", (long)4L, (long)this.bundle.getState());
        this.bundle.start();
        Assert.assertEquals((String)"Bundle ACTIVE", (long)32L, (long)this.bundle.getState());
        BundleContext context = this.bundle.getBundleContext();
        Assert.assertNotNull((String)"BundleContext available", (Object)context);
        ServiceReference sref = context.getServiceReference(SimpleService.class.getName());
        Assert.assertNotNull((String)"ServiceReference not null", (Object)sref);
        SimpleService service = (SimpleService)context.getService(sref);
        Assert.assertNotNull((String)"Service not null", (Object)service);
        int sum = service.sum(1, 2, 3);
        Assert.assertEquals((long)6L, (long)sum);
        this.bundle.stop();
        Assert.assertEquals((String)"Bundle RESOLVED", (long)4L, (long)this.bundle.getState());
    }
}

