/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.osgi.remote;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.jboss.arquillian.container.osgi.remote.RemoteContainerConfiguration;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.logging.Logger;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.osgi.testing.internal.ManagementSupport;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VFSUtils;
import org.jboss.osgi.vfs.VirtualFile;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.osgi.framework.BundleException;
import org.osgi.jmx.framework.BundleStateMBean;
import org.osgi.jmx.framework.FrameworkMBean;

public class RemoteDeployableContainer
implements DeployableContainer<RemoteContainerConfiguration> {
    private static final Logger log = Logger.getLogger((String)RemoteDeployableContainer.class.getName());
    @Inject
    @ContainerScoped
    private InstanceProducer<MBeanServerConnection> mbeanServerInst;
    private JMXConnector jmxConnector;
    private ManagementSupport jmxSupport;
    private Map<String, BundleHandle> deployedBundles = new HashMap<String, BundleHandle>();

    public Class<RemoteContainerConfiguration> getConfigurationClass() {
        return RemoteContainerConfiguration.class;
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("jmx-osgi");
    }

    public void setup(RemoteContainerConfiguration configuration) {
        MBeanServerConnection mbeanServer = this.getMBeanServerConnection(configuration);
        this.mbeanServerInst.set((Object)mbeanServer);
        this.jmxSupport = new ManagementSupport(mbeanServer);
    }

    public void start() throws LifecycleException {
        List<BundleHandle> bundles = this.getBundles();
        if (this.getInstalledBundle(bundles, "arquillian-osgi-bundle") == null) {
            this.installBundle("arquillian-osgi-bundle", true);
        }
    }

    public void stop() throws LifecycleException {
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        try {
            BundleHandle handle = this.installBundle(archive);
            this.deployedBundles.put(archive.getName(), handle);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new DeploymentException("Cannot deploy: " + archive.getName(), (Throwable)ex);
        }
        return new ProtocolMetaData();
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        BundleHandle handle = this.deployedBundles.remove(archive.getName());
        if (handle != null) {
            try {
                FrameworkMBean frameworkMBean = this.jmxSupport.getFrameworkMBean();
                frameworkMBean.uninstallBundle(handle.getBundleId());
            }
            catch (IOException ex) {
                log.errorf((Throwable)ex, "Cannot undeploy: %s" + archive.getName(), new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BundleHandle installBundle(Archive<?> archive) throws BundleException, IOException {
        VirtualFile virtualFile = this.toVirtualFile(archive);
        try {
            BundleHandle bundleHandle = this.installBundle(virtualFile);
            return bundleHandle;
        }
        finally {
            VFSUtils.safeClose((Closeable)virtualFile);
        }
    }

    private VirtualFile toVirtualFile(Archive<?> archive) throws IOException {
        ZipExporter exporter = (ZipExporter)archive.as(ZipExporter.class);
        return AbstractVFS.toVirtualFile((String)archive.getName(), (InputStream)exporter.exportAsInputStream());
    }

    private BundleHandle installBundle(VirtualFile virtualFile) throws BundleException, IOException {
        BundleInfo info = BundleInfo.createBundleInfo((VirtualFile)virtualFile);
        String streamURL = info.getRoot().getStreamURL().toExternalForm();
        FrameworkMBean frameworkMBean = this.jmxSupport.getFrameworkMBean();
        long bundleId = frameworkMBean.installBundleFromURL(info.getLocation(), streamURL);
        return new BundleHandle(bundleId, info.getSymbolicName());
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("OSGi does not support Descriptor deployment");
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("OSGi does not support Descriptor deployment");
    }

    private MBeanServerConnection getMBeanServerConnection(RemoteContainerConfiguration config) {
        MBeanServerConnection mbeanServer;
        String host = config.getHost();
        int port = config.getPort();
        String path = config.getUrlPath();
        String urlString = "service:jmx:rmi:///jndi/rmi://" + host + ":" + port + "/" + path;
        try {
            if (this.jmxConnector == null) {
                log.debugf("Connecting JMXConnector to: %s", (Object)urlString);
                JMXServiceURL serviceURL = new JMXServiceURL(urlString);
                this.jmxConnector = JMXConnectorFactory.connect(serviceURL, null);
            }
            mbeanServer = this.jmxConnector.getMBeanServerConnection();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot obtain MBeanServerConnection to: " + urlString, ex);
        }
        return mbeanServer;
    }

    private List<BundleHandle> getBundles() throws LifecycleException {
        ArrayList<BundleHandle> bundleList = new ArrayList<BundleHandle>();
        try {
            BundleStateMBean bundleStateMBean = this.jmxSupport.getBundleStateMBean();
            TabularData listBundles = bundleStateMBean.listBundles();
            for (CompositeData bundleType : listBundles.values()) {
                Long bundleId = (Long)bundleType.get("Identifier");
                String symbolicName = (String)bundleType.get("SymbolicName");
                bundleList.add(new BundleHandle(bundleId, symbolicName));
            }
        }
        catch (IOException ex) {
            throw new LifecycleException("Cannot list bundles", (Throwable)ex);
        }
        return bundleList;
    }

    private BundleHandle getInstalledBundle(List<BundleHandle> bundles, String symbolicName) {
        for (BundleHandle aux : bundles) {
            if (!symbolicName.equals(aux.getSymbolicName())) continue;
            return aux;
        }
        return null;
    }

    private BundleHandle installBundle(String artifactId, boolean startBundle) {
        String[] paths;
        String classPath = System.getProperty("java.class.path");
        if (!classPath.contains(artifactId)) {
            log.debug((Object)("Class path does not contain '" + artifactId + "'"));
            return null;
        }
        for (String path : paths = classPath.split("" + File.pathSeparatorChar)) {
            if (!path.contains(artifactId)) continue;
            try {
                long bundleId = this.jmxSupport.getFrameworkMBean().installBundle(path);
                String symbolicName = this.jmxSupport.getBundleStateMBean().getSymbolicName(bundleId);
                BundleHandle handle = new BundleHandle(bundleId, symbolicName);
                if (startBundle) {
                    this.jmxSupport.getFrameworkMBean().startBundle(bundleId);
                }
                return handle;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    static class BundleHandle {
        private long bundleId;
        private String symbolicName;

        public BundleHandle(long bundleId, String symbolicName) {
            this.bundleId = bundleId;
            this.symbolicName = symbolicName;
        }

        public long getBundleId() {
            return this.bundleId;
        }

        public String getSymbolicName() {
            return this.symbolicName;
        }

        public String toString() {
            return "[" + this.bundleId + "]" + this.symbolicName;
        }
    }
}

