/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.osgi;

import java.io.InputStream;
import java.util.Collection;
import org.jboss.arquillian.container.test.spi.TestDeployment;
import org.jboss.arquillian.container.test.spi.client.deployment.DeploymentPackager;
import org.jboss.arquillian.container.test.spi.client.deployment.ProtocolArchiveProcessor;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class OSGiDeploymentPackager
implements DeploymentPackager {
    public Archive<?> generateDeployment(TestDeployment testDeployment, Collection<ProtocolArchiveProcessor> processors) {
        Archive bundleArchive = testDeployment.getApplicationArchive();
        if (JavaArchive.class.isInstance(bundleArchive)) {
            return this.handleArchive((JavaArchive)JavaArchive.class.cast(bundleArchive), testDeployment.getAuxiliaryArchives());
        }
        throw new IllegalArgumentException(OSGiDeploymentPackager.class.getName() + " can not handle archive of type " + bundleArchive.getClass().getName());
    }

    private Archive<?> handleArchive(JavaArchive archive, Collection<Archive<?>> auxiliaryArchives) {
        try {
            this.validateBundleArchive((Archive<?>)archive);
            return archive;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Not a valid OSGi bundle: " + archive, ex);
        }
    }

    private void validateBundleArchive(Archive<?> archive) throws Exception {
        ZipExporter exporter = (ZipExporter)archive.as(ZipExporter.class);
        InputStream inputStream = exporter.exportAsInputStream();
        VirtualFile virtualFile = AbstractVFS.toVirtualFile((InputStream)inputStream);
        BundleInfo.createBundleInfo((VirtualFile)virtualFile);
    }
}

