/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.osgi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import org.jboss.arquillian.container.osgi.OSGiContainerConfiguration;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.JMXContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.shrinkwrap.resolver.api.DependencyResolutionFilter;
import org.jboss.shrinkwrap.resolver.api.DependencyResolvers;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependencyResolver;
import org.jboss.shrinkwrap.resolver.api.maven.filter.StrictFilter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

public abstract class AbstractEmbeddedDeployableContainer<T extends OSGiContainerConfiguration>
implements DeployableContainer<T> {
    private static final Logger log = Logger.getLogger(AbstractEmbeddedDeployableContainer.class.getName());
    private Framework framework;
    private BundleContext syscontext;
    private Map<String, String> configuration;
    private MBeanServerConnection mbeanServer;

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("jmx-osgi");
    }

    public void setup(T conf) {
        this.configuration = ((OSGiContainerConfiguration)conf).getFrameworkConfiguration();
        this.framework = this.createFramework(conf);
        this.mbeanServer = this.getMBeanServerConnection();
    }

    protected Framework createFramework(T conf) {
        FrameworkFactory factory = ((OSGiContainerConfiguration)conf).getFrameworkFactory();
        Map<String, String> config = ((OSGiContainerConfiguration)conf).getFrameworkConfiguration();
        return factory.newFramework(config);
    }

    public void start() throws LifecycleException {
        try {
            this.framework.start();
            this.syscontext = this.framework.getBundleContext();
        }
        catch (BundleException ex) {
            throw new LifecycleException("Cannot start embedded OSGi Framework", (Throwable)ex);
        }
    }

    protected void installArquillianBundle() throws LifecycleException {
        Bundle arqBundle = this.getInstalledBundle("arquillian-osgi-bundle");
        if (arqBundle == null) {
            try {
                String arqVersion = AbstractEmbeddedDeployableContainer.class.getPackage().getImplementationVersion();
                arqBundle = this.installBundle("org.jboss.arquillian.osgi", "arquillian-osgi-bundle", arqVersion, true);
            }
            catch (BundleException ex) {
                throw new LifecycleException("Cannot install arquillian-osgi-bundle", (Throwable)ex);
            }
        }
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public BundleContext getSystemContext() {
        return this.syscontext;
    }

    public void stop() throws LifecycleException {
        try {
            this.framework.stop();
            this.framework.waitForStop(3000L);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new LifecycleException("Cannot stop embedded OSGi Framework", (Throwable)ex);
        }
        finally {
            this.syscontext = null;
        }
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        try {
            ZipExporter exporter = (ZipExporter)archive.as(ZipExporter.class);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            exporter.exportTo((OutputStream)baos);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(baos.toByteArray());
            this.syscontext.installBundle(archive.getName(), (InputStream)inputStream);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new DeploymentException("Cannot deploy: " + archive, (Throwable)ex);
        }
        return new ProtocolMetaData().addContext((Object)new JMXContext(this.mbeanServer));
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        try {
            for (Bundle aux : this.syscontext.getBundles()) {
                if (!aux.getLocation().equals(archive.getName()) || aux.getState() == 1) continue;
                aux.uninstall();
                break;
            }
        }
        catch (BundleException ex) {
            log.log(Level.SEVERE, "Cannot undeploy: " + archive, ex);
        }
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("OSGi does not support Descriptor deployment");
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("OSGi does not support Descriptor deployment");
    }

    private Bundle getInstalledBundle(String symbolicName) {
        for (Bundle aux : this.syscontext.getBundles()) {
            if (!symbolicName.equals(aux.getSymbolicName())) continue;
            return aux;
        }
        return null;
    }

    private Bundle installBundle(String groupId, String artifactId, String version, boolean startBundle) throws BundleException {
        String filespec = groupId + ":" + artifactId + ":jar:" + version;
        MavenDependencyResolver resolver = (MavenDependencyResolver)DependencyResolvers.use(MavenDependencyResolver.class);
        File[] resolved = ((MavenDependencyResolver)resolver.artifact(filespec)).resolveAsFiles((DependencyResolutionFilter)new StrictFilter());
        if (resolved == null || resolved.length == 0) {
            throw new BundleException("Cannot obtain maven artifact: " + filespec);
        }
        if (resolved.length > 1) {
            throw new BundleException("Multiple maven artifacts for: " + filespec);
        }
        File bundleFile = resolved[0];
        try {
            Bundle bundle = this.syscontext.installBundle(bundleFile.toURI().toString());
            if (startBundle) {
                bundle.start();
            }
            return bundle;
        }
        catch (BundleException ex) {
            log.log(Level.SEVERE, "Cannot install/start bundle: " + bundleFile, ex);
            return null;
        }
    }

    private MBeanServerConnection getMBeanServerConnection() {
        MBeanServer mbeanServer = null;
        ArrayList<MBeanServer> serverArr = MBeanServerFactory.findMBeanServer(null);
        if (serverArr.size() > 1) {
            log.warning("Multiple MBeanServer instances: " + serverArr);
        }
        if (serverArr.size() > 0) {
            mbeanServer = serverArr.get(0);
            log.fine("Found MBeanServer: " + mbeanServer.getDefaultDomain());
        }
        if (mbeanServer == null) {
            log.fine("No MBeanServer, create one ...");
            mbeanServer = MBeanServerFactory.createMBeanServer();
        }
        return mbeanServer;
    }
}

