/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.osgi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;
import org.osgi.framework.launch.FrameworkFactory;

public class OSGiContainerConfiguration
implements ContainerConfiguration {
    private final Map<String, String> frameworkConfiguration = new HashMap<String, String>();
    private FrameworkFactory frameworkFactory;
    private String frameworkProperties;

    public void validate() throws ConfigurationException {
        if (this.frameworkProperties == null) {
            throw new ConfigurationException("Cannot obtain frameworkProperties");
        }
        File file = new File(this.frameworkProperties);
        try {
            FileInputStream input = new FileInputStream(file);
            Properties props = new Properties();
            props.load(input);
            for (String key : props.stringPropertyNames()) {
                this.frameworkConfiguration.put(key, props.getProperty(key));
            }
        }
        catch (IOException ex) {
            throw new ConfigurationException("Cannot read: " + file.getAbsolutePath());
        }
        Iterator<FrameworkFactory> factories = ServiceLoader.load(FrameworkFactory.class).iterator();
        if (!factories.hasNext()) {
            throw new ConfigurationException("Cannot obtain " + FrameworkFactory.class.getName() + " service");
        }
        this.frameworkFactory = factories.next();
    }

    public String getFrameworkProperties() {
        return this.frameworkProperties;
    }

    public void setFrameworkProperties(String frameworkProperties) {
        this.frameworkProperties = frameworkProperties;
    }

    public FrameworkFactory getFrameworkFactory() {
        return this.frameworkFactory;
    }

    public Map<String, String> getFrameworkConfiguration() {
        return Collections.unmodifiableMap(this.frameworkConfiguration);
    }
}

