/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.osgi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import org.jboss.arquillian.container.osgi.OSGiContainerConfiguration;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.JMXContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.ServiceTracker;

public abstract class EmbeddedDeployableContainer<T extends OSGiContainerConfiguration>
implements DeployableContainer<T> {
    private ContainerLogger log;
    private Framework framework;
    private BundleContext syscontext;
    private MBeanServerConnection mbeanServer;
    private OSGiContainerConfiguration configuration;

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("jmx-osgi");
    }

    public void setup(T configuration) {
        this.configuration = configuration;
        this.log = this.getLogger();
        this.framework = this.createFramework(configuration);
        this.mbeanServer = this.getMBeanServerConnection();
    }

    protected OSGiContainerConfiguration getContainerConfiguration() {
        return this.configuration;
    }

    protected ContainerLogger getLogger() {
        return new AbstractContainerLogger(){

            @Override
            public void log(ContainerLogger.Level level, String message, Throwable th) {
                System.out.println(message);
                if (th != null) {
                    th.printStackTrace();
                }
            }
        };
    }

    protected Framework createFramework(T conf) {
        FrameworkFactory factory = ((OSGiContainerConfiguration)conf).getFrameworkFactory();
        if (factory == null) {
            throw new IllegalStateException("Cannot obtain " + FrameworkFactory.class.getName());
        }
        Map<String, String> config = ((OSGiContainerConfiguration)conf).getFrameworkConfiguration();
        return factory.newFramework(config);
    }

    protected Framework getFramework() {
        return this.framework;
    }

    protected BundleContext startFramework() throws BundleException {
        this.framework.start();
        return this.framework.getBundleContext();
    }

    protected void stopFramework() throws BundleException {
        this.framework.stop();
    }

    protected Bundle installBundle(String location, InputStream inputStream) throws BundleException {
        return this.syscontext.installBundle(location, inputStream);
    }

    protected void uninstallBundle(Bundle bundle) throws BundleException {
        bundle.uninstall();
    }

    public void start() throws LifecycleException {
        String bootstrapCompleteService;
        this.log.debug("Starting OSGi embedded container: " + this.getClass().getName());
        try {
            this.syscontext = this.startFramework();
        }
        catch (BundleException ex) {
            throw new LifecycleException("Cannot start embedded OSGi Framework", (Throwable)ex);
        }
        this.installArquillianBundle();
        EmbeddedDeployableContainer.awaitArquillianBundleActive(this.syscontext);
        if (this.configuration.isAwaitBeginningStartLevel().booleanValue()) {
            EmbeddedDeployableContainer.awaitFrameworkBeginningStartLevel(this.syscontext);
        }
        if ((bootstrapCompleteService = this.configuration.getBootstrapCompleteService()) != null) {
            EmbeddedDeployableContainer.awaitFrameworkBeginningStartLevel(this.syscontext);
        }
        this.log.info("Started OSGi embedded container: " + this.getClass().getName());
    }

    public static void awaitArquillianBundleActive(BundleContext syscontext) throws LifecycleException {
        final CountDownLatch latch = new CountDownLatch(1);
        BundleTracker<Bundle> tracker = new BundleTracker<Bundle>(syscontext, 32, null){

            public Bundle addingBundle(Bundle bundle, BundleEvent event) {
                super.addingBundle(bundle, event);
                if ("arquillian-osgi-bundle".equals(bundle.getSymbolicName())) {
                    latch.countDown();
                }
                return bundle;
            }
        };
        tracker.open();
        try {
            if (!latch.await(30L, TimeUnit.SECONDS)) {
                throw new LifecycleException("Framework startup timeout");
            }
        }
        catch (InterruptedException ex) {
            throw new LifecycleException("Framework startup interupted", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void awaitFrameworkBeginningStartLevel(BundleContext syscontext) {
        block7: {
            String beginningStartLevelProp = syscontext.getProperty("org.osgi.framework.startlevel.beginning");
            if (beginningStartLevelProp != null) {
                final CountDownLatch latch = new CountDownLatch(1);
                final Integer beginningStartLevel = Integer.parseInt(beginningStartLevelProp);
                final FrameworkStartLevel fwrkStartLevel = (FrameworkStartLevel)syscontext.getBundle().adapt(FrameworkStartLevel.class);
                FrameworkListener listener = new FrameworkListener(){

                    public void frameworkEvent(FrameworkEvent event) {
                        int startLevel;
                        if (event.getType() == 8 && (startLevel = fwrkStartLevel.getStartLevel()) == beginningStartLevel) {
                            latch.countDown();
                        }
                    }
                };
                syscontext.addFrameworkListener(listener);
                try {
                    int startLevel = fwrkStartLevel.getStartLevel();
                    if (startLevel >= beginningStartLevel) break block7;
                    try {
                        if (!latch.await(30L, TimeUnit.SECONDS)) {
                            throw new IllegalStateException("Giving up waiting to reach start level: " + beginningStartLevel);
                        }
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                finally {
                    syscontext.removeFrameworkListener(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void awaitBootstrapCompleteService(BundleContext syscontext, String serviceName) {
        final CountDownLatch latch = new CountDownLatch(1);
        ServiceTracker tracker = new ServiceTracker(syscontext, serviceName, null){

            public Object addingService(ServiceReference sref) {
                Object service = super.addingService(sref);
                latch.countDown();
                return service;
            }
        };
        tracker.open();
        try {
            if (!latch.await(30L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Giving up waiting for bootstrap service: " + serviceName);
            }
        }
        catch (InterruptedException e) {
        }
        finally {
            tracker.close();
        }
    }

    protected void installArquillianBundle() throws LifecycleException {
        Bundle arqBundle = this.getInstalledBundle("arquillian-osgi-bundle");
        if (arqBundle == null) {
            try {
                String arqVersion = EmbeddedDeployableContainer.class.getPackage().getImplementationVersion();
                if (arqVersion == null) {
                    arqVersion = System.getProperty("arquillian.osgi.version");
                }
                arqBundle = this.installBundle("org.jboss.arquillian.osgi", "arquillian-osgi-bundle", arqVersion, true);
            }
            catch (BundleException ex) {
                throw new LifecycleException("Cannot install arquillian-osgi-bundle", (Throwable)ex);
            }
        }
    }

    public void stop() throws LifecycleException {
        try {
            this.stopFramework();
            this.framework.waitForStop(3000L);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new LifecycleException("Cannot stop embedded OSGi Framework", (Throwable)ex);
        }
        finally {
            this.syscontext = null;
        }
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        try {
            ZipExporter exporter = (ZipExporter)archive.as(ZipExporter.class);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            exporter.exportTo((OutputStream)baos);
            String location = archive.getName();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(baos.toByteArray());
            this.log.info("Installing bundle: " + location);
            this.installBundle(location, inputStream);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new DeploymentException("Cannot deploy: " + archive, (Throwable)ex);
        }
        return new ProtocolMetaData().addContext((Object)new JMXContext(this.mbeanServer));
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        try {
            String location = archive.getName();
            this.log.info("Uninstalling bundle: " + location);
            Bundle bundle = this.syscontext.getBundle(location);
            if (bundle != null && bundle.getState() != 1) {
                this.uninstallBundle(bundle);
            }
        }
        catch (BundleException ex) {
            this.log.warn("Cannot undeploy: " + archive, ex);
        }
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("OSGi does not support Descriptor deployment");
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("OSGi does not support Descriptor deployment");
    }

    private Bundle getInstalledBundle(String symbolicName) {
        for (Bundle aux : this.syscontext.getBundles()) {
            if (!symbolicName.equals(aux.getSymbolicName())) continue;
            return aux;
        }
        return null;
    }

    private Bundle installBundle(String groupId, String artifactId, String version, boolean startBundle) throws BundleException {
        String filespec = groupId + ":" + artifactId + ":jar:" + version;
        File[] resolved = ((MavenFormatStage)((MavenStrategyStage)Maven.resolver().resolve(filespec)).withoutTransitivity()).asFile();
        if (resolved == null || resolved.length == 0) {
            throw new BundleException("Cannot obtain maven artifact: " + filespec);
        }
        if (resolved.length != 1) {
            if (version.endsWith("SNAPSHOT")) {
                throw new BundleException("Multiple maven artifacts for: " + filespec);
            }
            throw new BundleException("Multiple maven artifacts for: " + filespec);
        }
        File bundleFile = resolved[0];
        String location = bundleFile.toURI().toString();
        this.log.info("Installing bundle: " + location);
        try {
            Bundle bundle = this.installBundle(location, null);
            if (startBundle) {
                bundle.start();
            }
            return bundle;
        }
        catch (BundleException ex) {
            this.log.error("Cannot install/start bundle: " + bundleFile, ex);
            return null;
        }
    }

    private MBeanServerConnection getMBeanServerConnection() {
        MBeanServer mbeanServer = null;
        ArrayList<MBeanServer> serverArr = MBeanServerFactory.findMBeanServer(null);
        if (serverArr.size() > 1) {
            this.log.warn("Multiple MBeanServer instances: " + serverArr);
        }
        if (serverArr.size() > 0) {
            mbeanServer = serverArr.get(0);
            this.log.debug("Found MBeanServer: " + mbeanServer.getDefaultDomain());
        }
        if (mbeanServer == null) {
            this.log.debug("No MBeanServer, create one ...");
            mbeanServer = MBeanServerFactory.createMBeanServer();
        }
        return mbeanServer;
    }

    public static abstract class AbstractContainerLogger
    implements ContainerLogger {
        @Override
        public void debug(String message) {
            this.log(ContainerLogger.Level.DEBUG, message, null);
        }

        @Override
        public void debug(String message, Throwable th) {
            this.log(ContainerLogger.Level.DEBUG, message, th);
        }

        @Override
        public void info(String message) {
            this.log(ContainerLogger.Level.INFO, message, null);
        }

        @Override
        public void info(String message, Throwable th) {
            this.log(ContainerLogger.Level.INFO, message, th);
        }

        @Override
        public void warn(String message) {
            this.log(ContainerLogger.Level.WARN, message, null);
        }

        @Override
        public void warn(String message, Throwable th) {
            this.log(ContainerLogger.Level.WARN, message, th);
        }

        @Override
        public void error(String message) {
            this.log(ContainerLogger.Level.ERROR, message, null);
        }

        @Override
        public void error(String message, Throwable th) {
            this.log(ContainerLogger.Level.ERROR, message, th);
        }

        @Override
        public void log(ContainerLogger.Level level, String message) {
            this.log(level, message, null);
        }
    }

    public static interface ContainerLogger {
        public void debug(String var1);

        public void debug(String var1, Throwable var2);

        public void info(String var1);

        public void info(String var1, Throwable var2);

        public void error(String var1);

        public void error(String var1, Throwable var2);

        public void warn(String var1);

        public void warn(String var1, Throwable var2);

        public void log(Level var1, String var2);

        public void log(Level var1, String var2, Throwable var3);

        public static enum Level {
            DEBUG,
            INFO,
            WARN,
            ERROR;

        }
    }
}

